/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.soundcloud;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudDataLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudDataReader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudFormatHandler;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.DefaultSoundCloudPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudClientIdTracker;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudDataReader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudFormatHandler;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHelper;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudHttpContextFilter;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudPlaylistLoader;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudTrackFormat;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundcloudAudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioItem;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.BasicAudioPlaylist;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class SoundCloudAudioSourceManager
implements AudioSourceManager,
HttpConfigurable {
    private static final int DEFAULT_SEARCH_RESULTS = 10;
    private static final int MAXIMUM_SEARCH_RESULTS = 200;
    private static final String MOBILE_URL_REGEX = "^(?:http://|https://|)soundcloud\\.app\\.goo\\.gl/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$";
    private static final String TRACK_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$";
    private static final String SHORT_TRACK_URL_REGEX = "^https://on.soundcloud\\.com/[a-zA-Z0-9-_]+/?(?:\\?.*|)$";
    private static final String UNLISTED_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)/s-([a-zA-Z0-9-_]+)(?:\\?.*|)$";
    private static final String LIKED_URL_REGEX = "^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/likes/?(?:\\?.*|)$";
    private static final String LIKED_USER_URN_REGEX = "\"urn\":\"soundcloud:users:([0-9]+)\",\"username\":\"([^\"]+)\"";
    private static final String SEARCH_PREFIX = "scsearch";
    private static final String SEARCH_PREFIX_DEFAULT = "scsearch:";
    private static final String SEARCH_REGEX = "scsearch\\[([0-9]{1,9}),([0-9]{1,9})\\]:\\s*(.*)\\s*";
    private static final Pattern mobileUrlPattern = Pattern.compile("^(?:http://|https://|)soundcloud\\.app\\.goo\\.gl/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$");
    private static final Pattern trackUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)/?(?:\\?.*|)$");
    private static final Pattern shortTrackUrlPattern = Pattern.compile("^https://on.soundcloud\\.com/[a-zA-Z0-9-_]+/?(?:\\?.*|)$");
    private static final Pattern unlistedUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/([a-zA-Z0-9-_]+)/s-([a-zA-Z0-9-_]+)(?:\\?.*|)$");
    private static final Pattern likedUrlPattern = Pattern.compile("^(?:http://|https://|)(?:www\\.|)(?:m\\.|)soundcloud\\.com/([a-zA-Z0-9-_]+)/likes/?(?:\\?.*|)$");
    private static final Pattern likedUserUrnPattern = Pattern.compile("\"urn\":\"soundcloud:users:([0-9]+)\",\"username\":\"([^\"]+)\"");
    private static final Pattern searchPattern = Pattern.compile("scsearch\\[([0-9]{1,9}),([0-9]{1,9})\\]:\\s*(.*)\\s*");
    private final SoundCloudDataReader dataReader;
    private final SoundCloudDataLoader dataLoader;
    private final SoundCloudFormatHandler formatHandler;
    private final SoundCloudPlaylistLoader playlistLoader;
    private final HttpInterfaceManager httpInterfaceManager;
    private final SoundCloudClientIdTracker clientIdTracker;
    private final boolean allowSearch;

    public static SoundCloudAudioSourceManager createDefault() {
        DefaultSoundCloudDataReader dataReader = new DefaultSoundCloudDataReader();
        DefaultSoundCloudDataLoader dataLoader = new DefaultSoundCloudDataLoader();
        DefaultSoundCloudFormatHandler formatHandler = new DefaultSoundCloudFormatHandler();
        return new SoundCloudAudioSourceManager(true, dataReader, dataLoader, formatHandler, new DefaultSoundCloudPlaylistLoader(dataLoader, dataReader, formatHandler));
    }

    public static Builder builder() {
        return new Builder();
    }

    public SoundCloudAudioSourceManager(boolean allowSearch, SoundCloudDataReader dataReader, SoundCloudDataLoader dataLoader, SoundCloudFormatHandler formatHandler, SoundCloudPlaylistLoader playlistLoader) {
        this.allowSearch = allowSearch;
        this.dataReader = dataReader;
        this.dataLoader = dataLoader;
        this.formatHandler = formatHandler;
        this.playlistLoader = playlistLoader;
        this.httpInterfaceManager = HttpClientTools.createDefaultThreadLocalManager();
        this.clientIdTracker = new SoundCloudClientIdTracker(this.httpInterfaceManager);
        this.httpInterfaceManager.setHttpContextFilter(new SoundCloudHttpContextFilter(this.clientIdTracker));
    }

    public SoundCloudFormatHandler getFormatHandler() {
        return this.formatHandler;
    }

    @Override
    public String getSourceName() {
        return "soundcloud";
    }

    @Override
    public AudioItem loadItem(AudioPlayerManager manager, AudioReference reference) {
        AudioItem track;
        Matcher shortTrackMatcher;
        Matcher mobileUrlMatcher = mobileUrlPattern.matcher(reference.identifier);
        if (mobileUrlMatcher.matches()) {
            reference = SoundCloudHelper.redirectMobileLink(this.httpInterfaceManager.getInterface(), reference);
        }
        if ((shortTrackMatcher = shortTrackUrlPattern.matcher(reference.identifier)).matches()) {
            reference = SoundCloudHelper.resolveShortTrackUrl(this.httpInterfaceManager.getInterface(), reference);
        }
        if ((track = this.processAsSingleTrack(reference)) == null) {
            track = this.playlistLoader.load(reference.identifier, this.httpInterfaceManager, this::buildTrackFromInfo);
        }
        if (track == null) {
            track = this.processAsLikedTracks(reference);
        }
        if (track == null && this.allowSearch) {
            track = this.processAsSearchQuery(reference);
        }
        return track;
    }

    @Override
    public boolean isTrackEncodable(AudioTrack track) {
        return true;
    }

    @Override
    public void encodeTrack(AudioTrack track, DataOutput output) throws IOException {
        if (track.getInfo() instanceof SoundcloudAudioTrackInfo) {
            SoundcloudAudioTrackInfo trackInfo = (SoundcloudAudioTrackInfo)track.getInfo();
            output.writeUTF(trackInfo.monetizationModel);
            output.writeBoolean(trackInfo.snipped);
        }
    }

    @Override
    public AudioTrack decodeTrack(AudioTrackInfo trackInfo, DataInput input) throws IOException {
        DataInputStream stream = (DataInputStream)input;
        if (stream.available() <= 8 || !stream.markSupported()) {
            return new SoundCloudAudioTrack(trackInfo, this);
        }
        stream.mark(1024);
        AudioTrackInfo info = trackInfo;
        try {
            short mmLength = input.readShort();
            stream.reset();
            if (mmLength == 0 || mmLength > 15) {
                return new SoundCloudAudioTrack(trackInfo, this);
            }
            String monetizationModel = input.readUTF();
            boolean snipped = input.readBoolean();
            info = new SoundcloudAudioTrackInfo(trackInfo.title, trackInfo.author, trackInfo.length, trackInfo.identifier, trackInfo.isStream, trackInfo.uri, monetizationModel, snipped);
        }
        catch (IOException e) {
            stream.reset();
        }
        return new SoundCloudAudioTrack(info, this);
    }

    @Override
    public void shutdown() {
    }

    public String getClientId() {
        return this.clientIdTracker.getClientId();
    }

    public HttpInterface getHttpInterface() {
        return this.httpInterfaceManager.getInterface();
    }

    @Override
    public void configureRequests(Function<RequestConfig, RequestConfig> configurator) {
        this.httpInterfaceManager.configureRequests(configurator);
    }

    @Override
    public void configureBuilder(Consumer<HttpClientBuilder> configurator) {
        this.httpInterfaceManager.configureBuilder(configurator);
    }

    private AudioTrack processAsSingleTrack(AudioReference reference) {
        String url = SoundCloudHelper.nonMobileUrl(reference.identifier);
        Matcher trackUrlMatcher = trackUrlPattern.matcher(url);
        if (trackUrlMatcher.matches() && !"likes".equals(trackUrlMatcher.group(2))) {
            return this.loadTrack(url);
        }
        Matcher unlistedUrlMatcher = unlistedUrlPattern.matcher(url);
        if (unlistedUrlMatcher.matches()) {
            return this.loadTrack(url);
        }
        return null;
    }

    private AudioItem processAsLikedTracks(AudioReference reference) {
        String url = SoundCloudHelper.nonMobileUrl(reference.identifier);
        if (likedUrlPattern.matcher(url).matches()) {
            return this.loadFromLikedTracks(url);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioTrack loadTrack(String trackWebUrl) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            JsonBrowser rootData = this.dataLoader.load(httpInterface, trackWebUrl);
            JsonBrowser trackData = this.dataReader.findTrackData(rootData);
            if (trackData == null) {
                throw new FriendlyException("This track is not available", FriendlyException.Severity.COMMON, null);
            }
            AudioTrack audioTrack = this.loadFromTrackData(trackData);
            return audioTrack;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading track from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    protected AudioTrack loadFromTrackData(JsonBrowser trackData) {
        SoundCloudTrackFormat format = this.formatHandler.chooseBestFormat(this.dataReader.readTrackFormats(trackData));
        return this.buildTrackFromInfo(this.dataReader.readTrackInfo(trackData, this.formatHandler.buildFormatIdentifier(format)));
    }

    private AudioTrack buildTrackFromInfo(AudioTrackInfo trackInfo) {
        return new SoundCloudAudioTrack(trackInfo, this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AudioItem loadFromLikedTracks(String likedListUrl) {
        try (HttpInterface httpInterface = this.getHttpInterface();){
            UserInfo userInfo = this.findUserIdFromLikedList(httpInterface, likedListUrl);
            if (userInfo == null) {
                AudioReference audioReference = AudioReference.NO_TRACK;
                return audioReference;
            }
            AudioItem audioItem = this.extractTracksFromLikedList(this.loadLikedListForUserId(httpInterface, userInfo), userInfo);
            return audioItem;
        }
        catch (IOException e) {
            throw new FriendlyException("Loading liked tracks from SoundCloud failed.", FriendlyException.Severity.SUSPICIOUS, e);
        }
    }

    private UserInfo findUserIdFromLikedList(HttpInterface httpInterface, String likedListUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(likedListUrl));){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 404) {
                UserInfo userInfo = null;
                return userInfo;
            }
            if (!HttpClientTools.isSuccessWithContent(statusCode)) {
                throw new IOException("Invalid status code for track list response: " + statusCode);
            }
            Matcher matcher = likedUserUrnPattern.matcher(IOUtils.toString(response.getEntity().getContent(), StandardCharsets.UTF_8));
            UserInfo userInfo = matcher.find() ? new UserInfo(matcher.group(1), matcher.group(2)) : null;
            return userInfo;
        }
    }

    private JsonBrowser loadLikedListForUserId(HttpInterface httpInterface, UserInfo userInfo) throws IOException {
        URI uri = URI.create("https://api-v2.soundcloud.com/users/" + userInfo.id + "/likes?limit=200&offset=0");
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet(uri));){
            HttpClientTools.assertSuccessWithContent(response, "liked tracks response");
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent());
            return jsonBrowser;
        }
    }

    private AudioItem extractTracksFromLikedList(JsonBrowser likedTracks, UserInfo userInfo) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser item : likedTracks.get("collection").values()) {
            JsonBrowser trackItem = item.get("track");
            if (trackItem.isNull() || this.dataReader.isTrackBlocked(trackItem)) continue;
            tracks.add(this.loadFromTrackData(trackItem));
        }
        return new BasicAudioPlaylist("Liked by " + userInfo.name, tracks, null, false);
    }

    private AudioItem processAsSearchQuery(AudioReference reference) {
        if (reference.identifier.startsWith(SEARCH_PREFIX)) {
            if (reference.identifier.startsWith(SEARCH_PREFIX_DEFAULT)) {
                return this.loadSearchResult(reference.identifier.substring(SEARCH_PREFIX_DEFAULT.length()).trim(), 0, 10);
            }
            Matcher searchMatcher = searchPattern.matcher(reference.identifier);
            if (searchMatcher.matches()) {
                return this.loadSearchResult(searchMatcher.group(3), Integer.parseInt(searchMatcher.group(1)), Integer.parseInt(searchMatcher.group(2)));
            }
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private AudioItem loadSearchResult(String query, int offset, int rawLimit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioItem loadSearchResultsFromResponse(HttpResponse response, String query) throws IOException {
        try {
            JsonBrowser searchResults = JsonBrowser.parse(response.getEntity().getContent());
            AudioItem audioItem = this.extractTracksFromSearchResults(query, searchResults);
            return audioItem;
        }
        finally {
            EntityUtils.consumeQuietly(response.getEntity());
        }
    }

    private URI buildSearchUri(String query, int offset, int limit) {
        try {
            return new URIBuilder("https://api-v2.soundcloud.com/search/tracks").addParameter("q", query).addParameter("offset", String.valueOf(offset)).addParameter("limit", String.valueOf(limit)).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private AudioItem extractTracksFromSearchResults(String query, JsonBrowser searchResults) {
        ArrayList<AudioTrack> tracks = new ArrayList<AudioTrack>();
        for (JsonBrowser item : searchResults.get("collection").values()) {
            if (item.isNull()) continue;
            tracks.add(this.loadFromTrackData(item));
        }
        return new BasicAudioPlaylist("Search results for: " + query, tracks, null, true);
    }

    public static class Builder {
        private boolean allowSearch = true;
        private SoundCloudDataReader dataReader;
        private SoundCloudDataLoader dataLoader;
        private SoundCloudFormatHandler formatHandler;
        private SoundCloudPlaylistLoader playlistLoader;
        private PlaylistLoaderFactory playlistLoaderFactory;

        public Builder withAllowSearch(boolean allowSearch) {
            this.allowSearch = allowSearch;
            return this;
        }

        public Builder withDataReader(SoundCloudDataReader dataReader) {
            this.dataReader = dataReader;
            return this;
        }

        public Builder withDataLoader(SoundCloudDataLoader dataLoader) {
            this.dataLoader = dataLoader;
            return this;
        }

        public Builder withFormatHandler(SoundCloudFormatHandler formatHandler) {
            this.formatHandler = formatHandler;
            return this;
        }

        public Builder withPlaylistLoader(SoundCloudPlaylistLoader playlistLoader) {
            this.playlistLoader = playlistLoader;
            return this;
        }

        public Builder withPlaylistLoaderFactory(PlaylistLoaderFactory playlistLoaderFactory) {
            this.playlistLoaderFactory = playlistLoaderFactory;
            return this;
        }

        public SoundCloudAudioSourceManager build() {
            PlaylistLoaderFactory factory;
            SoundCloudPlaylistLoader usedPlaylistLoader;
            SoundCloudFormatHandler usedFormatHandler;
            SoundCloudDataLoader usedDataLoader;
            SoundCloudDataReader usedDataReader = this.dataReader;
            if (usedDataReader == null) {
                usedDataReader = new DefaultSoundCloudDataReader();
            }
            if ((usedDataLoader = this.dataLoader) == null) {
                usedDataLoader = new DefaultSoundCloudDataLoader();
            }
            if ((usedFormatHandler = this.formatHandler) == null) {
                usedFormatHandler = new DefaultSoundCloudFormatHandler();
            }
            if ((usedPlaylistLoader = this.playlistLoader) == null && (factory = this.playlistLoaderFactory) != null) {
                usedPlaylistLoader = factory.create(usedDataReader, usedDataLoader, usedFormatHandler);
            }
            if (usedPlaylistLoader == null) {
                usedPlaylistLoader = new DefaultSoundCloudPlaylistLoader(usedDataLoader, usedDataReader, usedFormatHandler);
            }
            return new SoundCloudAudioSourceManager(this.allowSearch, usedDataReader, usedDataLoader, usedFormatHandler, usedPlaylistLoader);
        }

        @FunctionalInterface
        static interface PlaylistLoaderFactory {
            public SoundCloudPlaylistLoader create(SoundCloudDataReader var1, SoundCloudDataLoader var2, SoundCloudFormatHandler var3);
        }
    }

    private static class UserInfo {
        private final String id;
        private final String name;

        private UserInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

