/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.track.playback;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerOptions;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import com.sedmelluq.discord.lavaplayer.track.InternalAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import com.sedmelluq.discord.lavaplayer.track.TrackMarkerTracker;
import com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioProcessingContext;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalAudioTrackExecutor
implements AudioTrackExecutor {
    private static final Logger log = LoggerFactory.getLogger(LocalAudioTrackExecutor.class);
    private final InternalAudioTrack audioTrack;
    private final AudioProcessingContext processingContext;
    private final boolean useSeekGhosting;
    private final AudioFrameBuffer frameBuffer;
    private final AtomicReference<Thread> playingThread = new AtomicReference();
    private final AtomicBoolean disposedOf = new AtomicBoolean(false);
    private final AtomicLong queuedSeek = new AtomicLong(-1L);
    private final AtomicLong lastFrameTimecode = new AtomicLong(0L);
    private final AtomicReference<AudioTrackState> state = new AtomicReference<AudioTrackState>(AudioTrackState.INACTIVE);
    private final Object actionSynchronizer = new Object();
    private final TrackMarkerTracker markerTracker = new TrackMarkerTracker();
    private long externalSeekPosition = -1L;
    private boolean interruptibleForSeek = false;
    private volatile Throwable trackException;

    public LocalAudioTrackExecutor(InternalAudioTrack audioTrack, AudioConfiguration configuration, AudioPlayerOptions playerOptions, boolean useSeekGhosting, int bufferDuration) {
        this.audioTrack = audioTrack;
        AudioDataFormat currentFormat = configuration.getOutputFormat();
        this.frameBuffer = configuration.getFrameBufferFactory().create(bufferDuration, currentFormat, this.disposedOf);
        this.processingContext = new AudioProcessingContext(configuration, this.frameBuffer, playerOptions, currentFormat);
        this.useSeekGhosting = useSeekGhosting;
    }

    public AudioProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public StackTraceElement[] getStackTrace() {
        Thread thread = this.playingThread.get();
        if (thread != null) {
            StackTraceElement[] trace = thread.getStackTrace();
            if (this.playingThread.get() == thread) {
                return trace;
            }
        }
        return null;
    }

    @Override
    public AudioFrameBuffer getAudioBuffer() {
        return this.frameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TrackStateListener listener) {
        block23: {
            block24: {
                InterruptedException interrupt = null;
                if (Thread.interrupted()) {
                    log.debug("Cleared a stray interrupt.");
                }
                Object object = this.actionSynchronizer;
                synchronized (object) {
                    if (this.disposedOf.get()) {
                        log.debug("Attempt to execute executor that has been disposed of");
                        return;
                    }
                }
                if (!this.playingThread.compareAndSet(null, Thread.currentThread())) break block24;
                log.debug("Starting to play track {} locally with listener {}", (Object)this.audioTrack.getInfo().identifier, (Object)listener);
                this.state.set(AudioTrackState.LOADING);
                try {
                    this.audioTrack.process(this);
                    log.debug("Playing track {} finished or was stopped.", (Object)this.audioTrack.getIdentifier());
                    object = this.actionSynchronizer;
                }
                catch (Throwable e) {
                    Object object2;
                    try {
                        interrupt = this.findInterrupt(e);
                        if (interrupt != null) {
                            log.debug("Track {} was interrupted outside of execution loop.", (Object)this.audioTrack.getIdentifier());
                        } else {
                            this.frameBuffer.setTerminateOnEmpty();
                            FriendlyException exception = ExceptionTools.wrapUnfriendlyExceptions("Something broke when playing the track.", FriendlyException.Severity.FAULT, e);
                            ExceptionTools.log(log, exception, "playback of " + this.audioTrack.getIdentifier());
                            this.trackException = exception;
                            listener.onTrackException(this.audioTrack, exception);
                            ExceptionTools.rethrowErrors(e);
                        }
                        object2 = this.actionSynchronizer;
                    }
                    catch (Throwable throwable) {
                        Object object3 = this.actionSynchronizer;
                        synchronized (object3) {
                            interrupt = interrupt != null ? interrupt : this.findInterrupt(null);
                            this.playingThread.compareAndSet(Thread.currentThread(), null);
                            this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
                            this.state.set(AudioTrackState.FINISHED);
                        }
                        if (interrupt != null) {
                            Thread.currentThread().interrupt();
                        }
                        throw throwable;
                    }
                    synchronized (object2) {
                        interrupt = interrupt != null ? interrupt : this.findInterrupt(null);
                        this.playingThread.compareAndSet(Thread.currentThread(), null);
                        this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
                        this.state.set(AudioTrackState.FINISHED);
                    }
                    if (interrupt != null) {
                        Thread.currentThread().interrupt();
                    }
                    break block23;
                }
                synchronized (object) {
                    interrupt = interrupt != null ? interrupt : this.findInterrupt(null);
                    this.playingThread.compareAndSet(Thread.currentThread(), null);
                    this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
                    this.state.set(AudioTrackState.FINISHED);
                }
                if (interrupt != null) {
                    Thread.currentThread().interrupt();
                }
                break block23;
            }
            log.warn("Tried to start an already playing track {}", (Object)this.audioTrack.getIdentifier());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Object object = this.actionSynchronizer;
        synchronized (object) {
            this.disposedOf.set(true);
            Thread thread = this.playingThread.get();
            if (thread != null) {
                log.debug("Requesting stop for track {}", (Object)this.audioTrack.getIdentifier());
                thread.interrupt();
            } else {
                log.debug("Tried to stop track {} which is not playing.", (Object)this.audioTrack.getIdentifier());
            }
        }
    }

    public void waitOnEnd() throws InterruptedException {
        this.frameBuffer.setTerminateOnEmpty();
        this.frameBuffer.waitForTermination();
    }

    @Override
    public long getPosition() {
        long seek = this.queuedSeek.get();
        return seek != -1L ? seek : this.lastFrameTimecode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPosition(long timecode) {
        if (!this.audioTrack.isSeekable()) {
            return;
        }
        Object object = this.actionSynchronizer;
        synchronized (object) {
            if (timecode < 0L) {
                timecode = 0L;
            }
            this.queuedSeek.set(timecode);
            if (!this.useSeekGhosting) {
                this.frameBuffer.clear();
            }
            this.interruptForSeek();
        }
    }

    @Override
    public AudioTrackState getState() {
        return this.state.get();
    }

    private boolean isPerformingSeek() {
        return this.queuedSeek.get() != -1L || this.useSeekGhosting && this.frameBuffer.hasClearOnInsert();
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.markerTracker.set(marker, this.getPosition());
    }

    @Override
    public void addMarker(TrackMarker marker) {
        this.markerTracker.add(marker, this.getPosition());
    }

    @Override
    public void removeMarker(TrackMarker marker) {
        this.markerTracker.remove(marker);
    }

    @Override
    public boolean failedBeforeLoad() {
        return this.trackException != null && !this.frameBuffer.hasReceivedFrames();
    }

    public void executeProcessingLoop(ReadExecutor readExecutor, SeekExecutor seekExecutor) {
        this.executeProcessingLoop(readExecutor, seekExecutor, true);
    }

    public void executeProcessingLoop(ReadExecutor readExecutor, SeekExecutor seekExecutor, boolean waitOnEnd) {
        boolean proceed = true;
        if (this.checkPendingSeek(seekExecutor) == SeekResult.EXTERNAL_SEEK) {
            return;
        }
        while (proceed) {
            this.state.set(AudioTrackState.PLAYING);
            proceed = false;
            try {
                if (Thread.interrupted() && !this.handlePlaybackInterrupt(null, seekExecutor)) break;
                this.setInterruptibleForSeek(true);
                readExecutor.performRead();
                this.setInterruptibleForSeek(false);
                if (seekExecutor != null && this.externalSeekPosition != -1L) {
                    long nextPosition = this.externalSeekPosition;
                    this.externalSeekPosition = -1L;
                    this.performSeek(seekExecutor, nextPosition);
                    proceed = true;
                    continue;
                }
                if (!waitOnEnd) continue;
                this.waitOnEnd();
            }
            catch (Exception e) {
                this.setInterruptibleForSeek(false);
                InterruptedException interruption = this.findInterrupt(e);
                if (interruption != null) {
                    proceed = this.handlePlaybackInterrupt(interruption, seekExecutor);
                    continue;
                }
                throw ExceptionTools.wrapUnfriendlyExceptions("Something went wrong when decoding the track.", FriendlyException.Severity.FAULT, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInterruptibleForSeek(boolean state) {
        Object object = this.actionSynchronizer;
        synchronized (object) {
            this.interruptibleForSeek = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interruptForSeek() {
        boolean interrupted = false;
        Object object = this.actionSynchronizer;
        synchronized (object) {
            if (this.interruptibleForSeek) {
                this.interruptibleForSeek = false;
                Thread thread = this.playingThread.get();
                if (thread != null) {
                    thread.interrupt();
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            log.debug("Interrupting playing thread to perform a seek {}", (Object)this.audioTrack.getIdentifier());
        } else {
            log.debug("Seeking on track {} while not in playback loop.", (Object)this.audioTrack.getIdentifier());
        }
    }

    private boolean handlePlaybackInterrupt(InterruptedException interruption, SeekExecutor seekExecutor) {
        Thread.interrupted();
        if (this.disposedOf.get()) {
            this.markerTracker.trigger(TrackMarkerHandler.MarkerState.STOPPED);
            return false;
        }
        SeekResult seekResult = this.checkPendingSeek(seekExecutor);
        if (seekResult != SeekResult.NO_SEEK) {
            if (this.disposedOf.get()) {
                this.markerTracker.trigger(TrackMarkerHandler.MarkerState.STOPPED);
                return false;
            }
            return seekResult == SeekResult.INTERNAL_SEEK;
        }
        if (interruption != null) {
            Thread.currentThread().interrupt();
            throw new FriendlyException("The track was unexpectedly terminated.", FriendlyException.Severity.SUSPICIOUS, interruption);
        }
        return true;
    }

    private InterruptedException findInterrupt(Throwable throwable) {
        InterruptedIOException ioException;
        InterruptedException exception = ExceptionTools.findDeepException(throwable, InterruptedException.class);
        if (!(exception != null || (ioException = ExceptionTools.findDeepException(throwable, InterruptedIOException.class)) == null || ioException.getMessage() != null && ioException.getMessage().contains("timed out"))) {
            exception = new InterruptedException(ioException.getMessage());
        }
        if (exception == null && Thread.interrupted()) {
            return new InterruptedException();
        }
        return exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SeekResult checkPendingSeek(SeekExecutor seekExecutor) {
        long seekPosition;
        if (!this.audioTrack.isSeekable()) {
            return SeekResult.NO_SEEK;
        }
        Object object = this.actionSynchronizer;
        synchronized (object) {
            seekPosition = this.queuedSeek.get();
            if (seekPosition == -1L) {
                return SeekResult.NO_SEEK;
            }
            log.debug("Track {} interrupted for seeking to {}.", (Object)this.audioTrack.getIdentifier(), (Object)seekPosition);
            this.applySeekState(seekPosition);
        }
        if (seekExecutor != null) {
            this.performSeek(seekExecutor, seekPosition);
            return SeekResult.INTERNAL_SEEK;
        }
        this.externalSeekPosition = seekPosition;
        return SeekResult.EXTERNAL_SEEK;
    }

    private void performSeek(SeekExecutor seekExecutor, long seekPosition) {
        try {
            seekExecutor.performSeek(seekPosition);
        }
        catch (Exception e) {
            throw ExceptionTools.wrapUnfriendlyExceptions("Something went wrong when seeking to a position.", FriendlyException.Severity.FAULT, e);
        }
    }

    private void applySeekState(long seekPosition) {
        this.state.set(AudioTrackState.SEEKING);
        if (this.useSeekGhosting) {
            this.frameBuffer.setClearOnInsert();
        } else {
            this.frameBuffer.clear();
        }
        this.queuedSeek.set(-1L);
        this.markerTracker.checkSeekTimecode(seekPosition);
    }

    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.frameBuffer.provide();
        this.processProvidedFrame(frame);
        return frame;
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        AudioFrame frame = this.frameBuffer.provide(timeout, unit);
        this.processProvidedFrame(frame);
        return frame;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        if (this.frameBuffer.provide(targetFrame)) {
            this.processProvidedFrame(targetFrame);
            return true;
        }
        return false;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (this.frameBuffer.provide(targetFrame, timeout, unit)) {
            this.processProvidedFrame(targetFrame);
            return true;
        }
        return true;
    }

    private void processProvidedFrame(AudioFrame frame) {
        if (frame != null && !frame.isTerminator()) {
            if (!this.isPerformingSeek()) {
                this.markerTracker.checkPlaybackTimecode(frame.getTimecode());
            }
            this.lastFrameTimecode.set(frame.getTimecode());
        }
    }

    private static enum SeekResult {
        NO_SEEK,
        INTERNAL_SEEK,
        EXTERNAL_SEEK;

    }

    public static interface SeekExecutor {
        public void performSeek(long var1) throws Exception;
    }

    public static interface ReadExecutor {
        public void performRead() throws Exception;
    }
}

