/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.track.playback;

import com.sedmelluq.discord.lavaplayer.track.playback.AbstractMutableAudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class MutableAudioFrame
extends AbstractMutableAudioFrame {
    private ByteBuffer frameBuffer;
    private int framePosition;
    private int frameLength;
    private String[] flags;

    public MutableAudioFrame() {
        this.setFlags(AudioFrame.DEFAULT_FLAGS);
    }

    public void setBuffer(ByteBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        this.framePosition = frameBuffer.position();
        this.frameLength = frameBuffer.remaining();
    }

    public void store(byte[] buffer, int offset, int length) {
        this.frameBuffer.position(this.framePosition);
        this.frameBuffer.limit(this.frameBuffer.capacity());
        this.frameBuffer.put(buffer, offset, length);
        this.frameLength = length;
    }

    public void setFlags(String ... flags) {
        this.flags = flags;
    }

    public void addFlag(String flag) {
        int newLength = this.flags.length + 1;
        this.flags = Arrays.copyOf(this.flags, newLength);
        this.flags[newLength - 1] = flag;
    }

    @Override
    public int getDataLength() {
        return this.frameLength;
    }

    @Override
    public byte[] getData() {
        byte[] data = new byte[this.getDataLength()];
        this.getData(data, 0);
        return data;
    }

    @Override
    public void getData(byte[] buffer, int offset) {
        int previous = this.frameBuffer.position();
        this.frameBuffer.position(this.framePosition);
        this.frameBuffer.get(buffer, offset, this.frameLength);
        this.frameBuffer.position(previous);
    }

    @Override
    public String[] getFlags() {
        return this.flags;
    }
}

