/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.player.extras.stream;

import com.sedmelluq.discord.lavaplayer.filter.PcmFilterFactory;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEvent;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerPauseEvent;
import com.sedmelluq.discord.lavaplayer.player.event.PlayerResumeEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackEndEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackExceptionEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStartEvent;
import com.sedmelluq.discord.lavaplayer.player.event.TrackStuckEvent;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import com.sedmelluq.lava.player.extras.stream.StreamAudioPlayerManager;
import com.sedmelluq.lava.player.extras.stream.StreamInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamAudioPlayer
implements AudioPlayer {
    private static final Logger log = LoggerFactory.getLogger(StreamAudioPlayer.class);
    private final AudioPlayer fallback;
    private final StreamAudioPlayerManager manager;
    private final Object lock;
    private final List<AudioEventListener> listeners;
    private final DetachListener detachListener;
    private StreamInstance.Cursor streamCursor;

    public StreamAudioPlayer(AudioPlayer fallback, StreamAudioPlayerManager manager) {
        this.fallback = fallback;
        this.manager = manager;
        this.lock = new Object();
        this.listeners = new ArrayList<AudioEventListener>();
        this.detachListener = new DetachListener();
        fallback.addListener(new StreamEventListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioTrack getPlayingTrack() {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                return this.streamCursor.getTrack();
            }
            return this.fallback.getPlayingTrack();
        }
    }

    @Override
    public void playTrack(AudioTrack track) {
        this.startTrack(track, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startTrack(AudioTrack track, boolean noInterrupt) {
        if (track == null) {
            this.stopTrack();
        } else {
            Object object = this.lock;
            synchronized (object) {
                AudioTrack previousTrack = this.getPlayingTrack();
                if (noInterrupt && previousTrack != null) {
                    return false;
                }
                if (previousTrack != null) {
                    if (this.streamCursor == null) {
                        this.fallback.stopTrack();
                    } else {
                        this.detachStream();
                    }
                    this.dispatchEvent(new TrackEndEvent(this, previousTrack, AudioTrackEndReason.REPLACED));
                }
                this.streamCursor = this.manager.openTrack(track, this.detachListener);
                if (this.streamCursor == null) {
                    this.fallback.startTrack(track, false);
                }
                this.dispatchEvent(new TrackStartEvent(this, track));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTrack() {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                this.streamCursor.close();
                this.streamCursor = null;
            }
            this.fallback.stopTrack();
        }
    }

    @Override
    public int getVolume() {
        return this.fallback.getVolume();
    }

    @Override
    public void setVolume(int volume) {
        this.fallback.setVolume(volume);
    }

    @Override
    public void setFilterFactory(PcmFilterFactory factory) {
        this.fallback.setFilterFactory(factory);
    }

    @Override
    public void setFrameBufferDuration(Integer duration) {
        this.fallback.setFrameBufferDuration(duration);
    }

    @Override
    public boolean isPaused() {
        return this.fallback.isPaused();
    }

    @Override
    public void setPaused(boolean value) {
        this.fallback.setPaused(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                this.streamCursor.close();
                this.streamCursor = null;
            }
            this.fallback.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(AudioEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(AudioEventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.removeIf(audioEventListener -> audioEventListener == listener);
        }
    }

    @Override
    public void checkCleanup(long threshold) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioFrame provide() {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                AudioFrame frame = this.streamCursor.provide();
                if (frame != null) {
                    return frame;
                }
                if (this.streamCursor.getTrack() != null) {
                    return null;
                }
                this.detachStream();
            }
            return this.fallback.provide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                throw new UnsupportedOperationException();
            }
            return this.fallback.provide(timeout, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                throw new UnsupportedOperationException();
            }
            return this.fallback.provide(targetFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (this.streamCursor != null) {
                throw new UnsupportedOperationException();
            }
            return this.fallback.provide(targetFrame, timeout, unit);
        }
    }

    private void detachStream() {
        if (this.streamCursor != null) {
            this.streamCursor.close();
            this.streamCursor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent(AudioEvent event) {
        Object object = this.lock;
        synchronized (object) {
            for (AudioEventListener listener : this.listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Exception e) {
                    log.error("Handler of event {} threw an exception.", (Object)event, (Object)e);
                }
            }
        }
    }

    private class StreamEventListener
    extends AudioEventAdapter {
        private StreamEventListener() {
        }

        @Override
        public void onPlayerPause(AudioPlayer player) {
            StreamAudioPlayer.this.dispatchEvent(new PlayerPauseEvent(StreamAudioPlayer.this));
        }

        @Override
        public void onPlayerResume(AudioPlayer player) {
            StreamAudioPlayer.this.dispatchEvent(new PlayerResumeEvent(StreamAudioPlayer.this));
        }

        @Override
        public void onTrackStart(AudioPlayer player, AudioTrack track) {
            log.debug("Received start event from delegate player for track {}.", (Object)track.getIdentifier());
        }

        @Override
        public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
            if (endReason.mayStartNext || endReason == AudioTrackEndReason.CLEANUP) {
                StreamAudioPlayer.this.dispatchEvent(new TrackEndEvent(StreamAudioPlayer.this, track, endReason));
            }
        }

        @Override
        public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
            StreamAudioPlayer.this.dispatchEvent(new TrackExceptionEvent(StreamAudioPlayer.this, track, exception));
        }

        @Override
        public void onTrackStuck(AudioPlayer player, AudioTrack track, long thresholdMs) {
            StreamAudioPlayer.this.dispatchEvent(new TrackStuckEvent(StreamAudioPlayer.this, track, thresholdMs, null));
        }
    }

    private class DetachListener
    implements Consumer<StreamInstance.Cursor> {
        private DetachListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(StreamInstance.Cursor cursor) {
            Object object = StreamAudioPlayer.this.lock;
            synchronized (object) {
                if (StreamAudioPlayer.this.streamCursor == cursor) {
                    StreamAudioPlayer.this.detachStream();
                }
            }
        }
    }
}

