/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.json.ResolvedChannelData;
import discord4j.rest.util.PermissionSet;
import java.util.Objects;
import reactor.core.publisher.Mono;

@Experimental
public class ResolvedChannel
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ResolvedChannelData data;

    public ResolvedChannel(GatewayDiscordClient gateway, ResolvedChannelData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public ResolvedChannelData getData() {
        return this.data;
    }

    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    public String getName() {
        return this.data.name();
    }

    public Channel.Type getType() {
        return Channel.Type.of(this.data.type());
    }

    public PermissionSet getEffectivePermissions() {
        return PermissionSet.of(this.data.permissions());
    }

    public Mono<Channel> asFullChannel() {
        return this.gateway.getChannelById(this.getId());
    }

    public Mono<Channel> asFullChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getId());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "ResolvedChannel{data=" + this.data + '}';
    }
}

