/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.ImmutableComponentData;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class TextInput
extends ActionComponent {
    public static TextInput small(String customId) {
        return TextInput.of(Style.SHORT, customId, null, null, null, null, null);
    }

    public static TextInput small(String customId, String label) {
        return TextInput.of(Style.SHORT, customId, label, null, null, null, null);
    }

    public static TextInput small(String customId, String label, String placeholder) {
        return TextInput.of(Style.SHORT, customId, label, null, null, null, placeholder);
    }

    public static TextInput small(String customId, String label, int minLength, int maxLength) {
        return TextInput.of(Style.SHORT, customId, label, minLength, maxLength, null, null);
    }

    public static TextInput paragraph(String customId) {
        return TextInput.of(Style.PARAGRAPH, customId, null, null, null, null, null);
    }

    public static TextInput paragraph(String customId, String label) {
        return TextInput.of(Style.PARAGRAPH, customId, label, null, null, null, null);
    }

    public static TextInput paragraph(String customId, String label, String placeholder) {
        return TextInput.of(Style.PARAGRAPH, customId, label, null, null, null, placeholder);
    }

    public static TextInput paragraph(String customId, String label, int minLength, int maxLength) {
        return TextInput.of(Style.PARAGRAPH, customId, label, minLength, maxLength, null, null);
    }

    private static TextInput of(Style style, String customId, @Nullable String label, @Nullable Integer minLength, @Nullable Integer maxLength, @Nullable String value, @Nullable String placeholder) {
        ImmutableComponentData.Builder builder = ComponentData.builder().type(MessageComponent.Type.TEXT_INPUT.getValue()).style(style.getValue()).customId(customId);
        if (label != null) {
            builder.label(label);
        }
        if (minLength != null) {
            builder.minLength(minLength);
        }
        if (maxLength != null) {
            builder.maxLength(maxLength);
        }
        if (value != null) {
            builder.value(value);
        }
        if (placeholder != null) {
            builder.placeholder(placeholder);
        }
        return new TextInput(builder.build());
    }

    TextInput(ComponentData data) {
        super(data);
    }

    public Style getStyle() {
        return this.getData().style().toOptional().map(Style::of).orElseThrow(IllegalStateException::new);
    }

    public String getCustomId() {
        return this.getData().customId().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Optional<String> getLabel() {
        return this.getData().label().toOptional();
    }

    public int getMinLength() {
        return this.getData().minLength().toOptional().orElse(0);
    }

    public int getMaxLength() {
        return this.getData().maxLength().toOptional().orElse(4000);
    }

    public boolean isRequired() {
        return this.getData().required().toOptional().orElse(true);
    }

    public Optional<String> getValue() {
        return this.getData().value().toOptional();
    }

    public Optional<String> getPlaceholder() {
        return this.getData().placeholder().toOptional();
    }

    public TextInput required() {
        return this.required(true);
    }

    public TextInput required(boolean value) {
        return new TextInput(ComponentData.builder().from(this.getData()).required(value).build());
    }

    public TextInput prefilled(String value) {
        return new TextInput(ComponentData.builder().from(this.getData()).value(value).build());
    }

    public TextInput placeholder(String value) {
        return new TextInput(ComponentData.builder().from(this.getData()).placeholder(value).build());
    }

    public static enum Style {
        UNKNOWN(-1),
        SHORT(1),
        PARAGRAPH(2);

        private final int value;

        private Style(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Style of(int value) {
            switch (value) {
                case 1: {
                    return SHORT;
                }
                case 2: {
                    return PARAGRAPH;
                }
            }
            return UNKNOWN;
        }
    }
}

