/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.PartialSticker;
import discord4j.discordjson.json.StickerData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class Sticker
extends PartialSticker {
    public Sticker(GatewayDiscordClient gateway, StickerData data) {
        super(gateway, data);
    }

    public StickerData getData() {
        return (StickerData)super.getStickerData();
    }

    public Optional<Snowflake> getPackId() {
        return this.getData().packId().toOptional().map(Snowflake::of);
    }

    public Optional<String> getDescription() {
        return this.getData().description();
    }

    public List<String> getTags() {
        return this.getData().tags().toOptional().map(tags -> tags.split(", ")).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public boolean isAvailable() {
        return this.getData().available().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Type getType() {
        return Type.of(this.getData().type());
    }

    public static enum Type {
        UNKNOWN(0),
        STANDARD(1),
        GUILD(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return STANDARD;
                }
                case 2: {
                    return GUILD;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Format {
        UNKNOWN(0),
        PNG(1),
        APNG(2),
        LOTTIE(3);

        private final int value;

        private Format(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Format of(int value) {
            switch (value) {
                case 1: {
                    return PNG;
                }
                case 2: {
                    return APNG;
                }
                case 3: {
                    return LOTTIE;
                }
            }
            return UNKNOWN;
        }
    }
}

