/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.AutoModRuleEditSpecGenerator;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModActionMetaData;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.json.ImmutableAutoModActionData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="AutoModRuleEditSpecGenerator", generator="Immutables")
public final class AutoModRuleEditSpec
implements AutoModRuleEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name;
    private final int eventType;
    private final AutoModTriggerMetaData triggerMetaData_value;
    private final boolean triggerMetaData_absent;
    private final List<AutoModActionData> actions;
    private final boolean enabled;
    private final List<Snowflake> exemptRoles;
    private final List<Snowflake> exemptChannels;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private AutoModRuleEditSpec(String name, int eventType, boolean enabled) {
        this.name = Objects.requireNonNull(name, "name");
        this.eventType = eventType;
        this.enabled = enabled;
        this.reason = null;
        Possible triggerMetaData$impl = Possible.absent();
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.exemptRoles = this.initShim.exemptRoles();
        this.exemptChannels = this.initShim.exemptChannels();
        this.initShim = null;
    }

    private AutoModRuleEditSpec(Builder builder) {
        this.reason = builder.reason;
        this.name = builder.name;
        this.eventType = builder.eventType;
        Possible triggerMetaData$impl = builder.triggerMetaData_build();
        this.enabled = builder.enabled;
        if (builder.actionsIsSet()) {
            this.initShim.actions(AutoModRuleEditSpec.createUnmodifiableList(true, builder.actions));
        }
        if (builder.exemptRolesIsSet()) {
            this.initShim.exemptRoles(AutoModRuleEditSpec.createUnmodifiableList(true, builder.exemptRoles));
        }
        if (builder.exemptChannelsIsSet()) {
            this.initShim.exemptChannels(AutoModRuleEditSpec.createUnmodifiableList(true, builder.exemptChannels));
        }
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.exemptRoles = this.initShim.exemptRoles();
        this.exemptChannels = this.initShim.exemptChannels();
        this.initShim = null;
    }

    private AutoModRuleEditSpec(@Nullable String reason, String name, int eventType, Possible<AutoModTriggerMetaData> triggerMetaData, List<AutoModActionData> actions, boolean enabled, List<Snowflake> exemptRoles, List<Snowflake> exemptChannels) {
        this.reason = reason;
        this.name = name;
        this.eventType = eventType;
        Possible<AutoModTriggerMetaData> triggerMetaData$impl = triggerMetaData;
        this.initShim.actions(actions);
        this.enabled = enabled;
        this.initShim.exemptRoles(exemptRoles);
        this.initShim.exemptChannels(exemptChannels);
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.actions = this.initShim.actions();
        this.exemptRoles = this.initShim.exemptRoles();
        this.exemptChannels = this.initShim.exemptChannels();
        this.initShim = null;
    }

    private List<AutoModActionData> actionsInitialize() {
        return AutoModRuleEditSpecGenerator.super.actions();
    }

    private List<Snowflake> exemptRolesInitialize() {
        return AutoModRuleEditSpecGenerator.super.exemptRoles();
    }

    private List<Snowflake> exemptChannelsInitialize() {
        return AutoModRuleEditSpecGenerator.super.exemptChannels();
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int eventType() {
        return this.eventType;
    }

    @Override
    public Possible<AutoModTriggerMetaData> triggerMetaData() {
        return this.triggerMetaData_absent ? Possible.absent() : Possible.of(this.triggerMetaData_value);
    }

    @Override
    public List<AutoModActionData> actions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.actions() : this.actions;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public List<Snowflake> exemptRoles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exemptRoles() : this.exemptRoles;
    }

    @Override
    public List<Snowflake> exemptChannels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exemptChannels() : this.exemptChannels;
    }

    public final AutoModRuleEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new AutoModRuleEditSpec(value, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new AutoModRuleEditSpec(this.reason, newValue, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withEventType(int value) {
        if (this.eventType == value) {
            return this;
        }
        return new AutoModRuleEditSpec(this.reason, this.name, value, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public AutoModRuleEditSpec withTriggerMetaData(Possible<AutoModTriggerMetaData> value) {
        Possible<AutoModTriggerMetaData> newValue = Objects.requireNonNull(value);
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, newValue, this.actions, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public AutoModRuleEditSpec withTriggerMetaData(AutoModTriggerMetaData value) {
        Possible<AutoModTriggerMetaData> newValue = Possible.of(value);
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, newValue, this.actions, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withActions(AutoModActionData ... elements) {
        List<AutoModActionData> newValue = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), newValue, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withActions(Iterable<? extends AutoModActionData> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<AutoModActionData> newValue = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(elements, true, false));
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), newValue, this.enabled, this.exemptRoles, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, value, this.exemptRoles, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withExemptRoles(Snowflake ... elements) {
        List<Snowflake> newValue = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, newValue, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withExemptRoles(Iterable<? extends Snowflake> elements) {
        if (this.exemptRoles == elements) {
            return this;
        }
        List<Snowflake> newValue = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(elements, true, false));
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, newValue, this.exemptChannels);
    }

    public final AutoModRuleEditSpec withExemptChannels(Snowflake ... elements) {
        List<Snowflake> newValue = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(Arrays.asList(elements), true, false));
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, newValue);
    }

    public final AutoModRuleEditSpec withExemptChannels(Iterable<? extends Snowflake> elements) {
        if (this.exemptChannels == elements) {
            return this;
        }
        List<Snowflake> newValue = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(elements, true, false));
        return new AutoModRuleEditSpec(this.reason, this.name, this.eventType, this.triggerMetaData(), this.actions, this.enabled, this.exemptRoles, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoModRuleEditSpec && this.equalTo(0, (AutoModRuleEditSpec)another);
    }

    private boolean equalTo(int synthetic, AutoModRuleEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.eventType == another.eventType && this.triggerMetaData().equals(another.triggerMetaData()) && this.actions.equals(another.actions) && this.enabled == another.enabled && this.exemptRoles.equals(another.exemptRoles) && this.exemptChannels.equals(another.exemptChannels);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.eventType;
        h2 += (h2 << 5) + this.triggerMetaData().hashCode();
        h2 += (h2 << 5) + this.actions.hashCode();
        h2 += (h2 << 5) + Boolean.hashCode(this.enabled);
        h2 += (h2 << 5) + this.exemptRoles.hashCode();
        h2 += (h2 << 5) + this.exemptChannels.hashCode();
        return h2;
    }

    public String toString() {
        return "AutoModRuleEditSpec{reason=" + this.reason + ", name=" + this.name + ", eventType=" + this.eventType + ", triggerMetaData=" + this.triggerMetaData().toString() + ", actions=" + this.actions + ", enabled=" + this.enabled + ", exemptRoles=" + this.exemptRoles + ", exemptChannels=" + this.exemptChannels + "}";
    }

    public static AutoModRuleEditSpec of(String name, int eventType, boolean enabled) {
        return new AutoModRuleEditSpec(name, eventType, enabled);
    }

    public static AutoModRuleEditSpec copyOf(AutoModRuleEditSpecGenerator instance) {
        if (instance instanceof AutoModRuleEditSpec) {
            return (AutoModRuleEditSpec)instance;
        }
        return AutoModRuleEditSpec.builder().from(instance).build();
    }

    public boolean isTriggerMetaDataPresent() {
        return !this.triggerMetaData_absent;
    }

    public AutoModTriggerMetaData triggerMetaDataOrElse(AutoModTriggerMetaData defaultValue) {
        return !this.triggerMetaData_absent ? this.triggerMetaData_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AutoModRuleEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_EVENT_TYPE = 2L;
        private static final long INIT_BIT_ENABLED = 4L;
        private static final long OPT_BIT_ACTIONS = 1L;
        private static final long OPT_BIT_EXEMPT_ROLES = 2L;
        private static final long OPT_BIT_EXEMPT_CHANNELS = 4L;
        private long initBits = 7L;
        private long optBits;
        private Possible<AutoModTriggerMetaData> triggerMetaData_possible = Possible.absent();
        private String reason;
        private String name;
        private int eventType;
        private List<AutoModActionData> actions = new ArrayList<AutoModActionData>();
        private boolean enabled;
        private List<Snowflake> exemptRoles = new ArrayList<Snowflake>();
        private List<Snowflake> exemptChannels = new ArrayList<Snowflake>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AutoModRuleEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.eventType(instance.eventType());
            this.triggerMetaData(instance.triggerMetaData());
            this.addAllActions(instance.actions());
            this.enabled(instance.enabled());
            this.addAllExemptRoles(instance.exemptRoles());
            this.addAllExemptChannels(instance.exemptChannels());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder eventType(int eventType) {
            this.eventType = eventType;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder triggerMetaData(Possible<AutoModTriggerMetaData> value) {
            this.triggerMetaData_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder triggerMetaData(AutoModTriggerMetaData value) {
            this.triggerMetaData_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAction(AutoModActionData element) {
            element = ImmutableAutoModActionData.copyOf(element);
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addAction(int type, Possible<AutoModActionMetaData> metadata) {
            return this.addAction(ImmutableAutoModActionData.of(type, metadata));
        }

        @CanIgnoreReturnValue
        public final Builder addActions(AutoModActionData ... elements) {
            for (AutoModActionData element : elements) {
                element = ImmutableAutoModActionData.copyOf(element);
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder actions(Iterable<? extends AutoModActionData> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllActions(Iterable<? extends AutoModActionData> elements) {
            for (AutoModActionData autoModActionData : elements) {
                ImmutableAutoModActionData immutableAutoModActionData = ImmutableAutoModActionData.copyOf(autoModActionData);
                this.actions.add(Objects.requireNonNull(immutableAutoModActionData, "actions element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExemptRole(Snowflake element) {
            this.exemptRoles.add(Objects.requireNonNull(element, "exemptRoles element"));
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExemptRoles(Snowflake ... elements) {
            for (Snowflake element : elements) {
                this.exemptRoles.add(Objects.requireNonNull(element, "exemptRoles element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exemptRoles(Iterable<? extends Snowflake> elements) {
            this.exemptRoles.clear();
            return this.addAllExemptRoles(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExemptRoles(Iterable<? extends Snowflake> elements) {
            for (Snowflake snowflake : elements) {
                this.exemptRoles.add(Objects.requireNonNull(snowflake, "exemptRoles element"));
            }
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExemptChannel(Snowflake element) {
            this.exemptChannels.add(Objects.requireNonNull(element, "exemptChannels element"));
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addExemptChannels(Snowflake ... elements) {
            for (Snowflake element : elements) {
                this.exemptChannels.add(Objects.requireNonNull(element, "exemptChannels element"));
            }
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exemptChannels(Iterable<? extends Snowflake> elements) {
            this.exemptChannels.clear();
            return this.addAllExemptChannels(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllExemptChannels(Iterable<? extends Snowflake> elements) {
            for (Snowflake snowflake : elements) {
                this.exemptChannels.add(Objects.requireNonNull(snowflake, "exemptChannels element"));
            }
            this.optBits |= 4L;
            return this;
        }

        public AutoModRuleEditSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AutoModRuleEditSpec(this);
        }

        private boolean actionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean exemptRolesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean exemptChannelsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build AutoModRuleEditSpec, some of required attributes are not set " + attributes;
        }

        private Possible<AutoModTriggerMetaData> triggerMetaData_build() {
            return this.triggerMetaData_possible;
        }
    }

    @Generated(from="AutoModRuleEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte actionsBuildStage = 0;
        private List<AutoModActionData> actions;
        private byte exemptRolesBuildStage = 0;
        private List<Snowflake> exemptRoles;
        private byte exemptChannelsBuildStage = 0;
        private List<Snowflake> exemptChannels;

        private InitShim() {
        }

        List<AutoModActionData> actions() {
            if (this.actionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actionsBuildStage == 0) {
                this.actionsBuildStage = (byte)-1;
                this.actions = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(AutoModRuleEditSpec.this.actionsInitialize(), true, false));
                this.actionsBuildStage = 1;
            }
            return this.actions;
        }

        void actions(List<AutoModActionData> actions) {
            this.actions = actions;
            this.actionsBuildStage = 1;
        }

        List<Snowflake> exemptRoles() {
            if (this.exemptRolesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exemptRolesBuildStage == 0) {
                this.exemptRolesBuildStage = (byte)-1;
                this.exemptRoles = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(AutoModRuleEditSpec.this.exemptRolesInitialize(), true, false));
                this.exemptRolesBuildStage = 1;
            }
            return this.exemptRoles;
        }

        void exemptRoles(List<Snowflake> exemptRoles) {
            this.exemptRoles = exemptRoles;
            this.exemptRolesBuildStage = 1;
        }

        List<Snowflake> exemptChannels() {
            if (this.exemptChannelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exemptChannelsBuildStage == 0) {
                this.exemptChannelsBuildStage = (byte)-1;
                this.exemptChannels = AutoModRuleEditSpec.createUnmodifiableList(false, AutoModRuleEditSpec.createSafeList(AutoModRuleEditSpec.this.exemptChannelsInitialize(), true, false));
                this.exemptChannelsBuildStage = 1;
            }
            return this.exemptChannels;
        }

        void exemptChannels(List<Snowflake> exemptChannels) {
            this.exemptChannels = exemptChannels;
            this.exemptChannelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.actionsBuildStage == -1) {
                attributes.add("actions");
            }
            if (this.exemptRolesBuildStage == -1) {
                attributes.add("exemptRoles");
            }
            if (this.exemptChannelsBuildStage == -1) {
                attributes.add("exemptChannels");
            }
            return "Cannot build AutoModRuleEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

