/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.extensions.youtuberotator.planner;

import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import com.sedmelluq.lava.extensions.youtuberotator.tools.Tuple;
import com.sedmelluq.lava.extensions.youtuberotator.tools.ip.IpBlock;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.List;
import java.util.function.Predicate;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalancingIpRoutePlanner
extends AbstractRoutePlanner {
    private static final Logger log = LoggerFactory.getLogger(BalancingIpRoutePlanner.class);
    private final Predicate<InetAddress> ipFilter;

    public BalancingIpRoutePlanner(List<IpBlock> ipBlocks) {
        this(ipBlocks, i -> true);
    }

    public BalancingIpRoutePlanner(List<IpBlock> ipBlocks, Predicate<InetAddress> ipFilter) {
        this(ipBlocks, ipFilter, true);
    }

    public BalancingIpRoutePlanner(List<IpBlock> ipBlocks, Predicate<InetAddress> ipFilter, boolean handleSearchFailure) {
        super(ipBlocks, handleSearchFailure);
        this.ipFilter = ipFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Tuple<InetAddress, InetAddress> determineAddressPair(Tuple<Inet4Address, Inet6Address> remoteAddresses) throws HttpException {
        InetAddress remoteAddress;
        InetAddress localAddress;
        if (this.ipBlock.getType() == Inet4Address.class) {
            if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
            localAddress = this.getRandomAddress(this.ipBlock);
            remoteAddress = (InetAddress)remoteAddresses.l;
            return new Tuple<InetAddress, InetAddress>(localAddress, remoteAddress);
        } else {
            if (this.ipBlock.getType() != Inet6Address.class) throw new HttpException("Unknown IpBlock type: " + this.ipBlock.getType().getCanonicalName());
            if (remoteAddresses.r != null) {
                localAddress = this.getRandomAddress(this.ipBlock);
                remoteAddress = (InetAddress)remoteAddresses.r;
                return new Tuple<InetAddress, InetAddress>(localAddress, remoteAddress);
            } else {
                if (remoteAddresses.l == null) throw new HttpException("Could not resolve host");
                localAddress = null;
                remoteAddress = (InetAddress)remoteAddresses.l;
                log.warn("Could not look up AAAA record for host. Falling back to unbalanced IPv4.");
            }
        }
        return new Tuple<InetAddress, InetAddress>(localAddress, remoteAddress);
    }

    private InetAddress getRandomAddress(IpBlock ipBlock) {
        Object localAddress;
        BigInteger it = BigInteger.valueOf(0L);
        do {
            if (ipBlock.getSize().multiply(BigInteger.valueOf(2L)).compareTo(it) < 0) {
                throw new RuntimeException("Can't find a free ip");
            }
            it = it.add(BigInteger.ONE);
        } while ((localAddress = ipBlock.getRandomAddress()) == null || !this.ipFilter.test((InetAddress)localAddress) || !this.isValidAddress((InetAddress)localAddress));
        return localAddress;
    }
}

