/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.youtube.packets;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.youtube.packets.EmptyPacket;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public abstract class Packet {
    protected JsonObject source;

    protected Packet() {
    }

    public static String stringFromPath(JsonElement json, String path) {
        String[] names = path.split("\\.");
        JsonElement current = json;
        for (String name : names) {
            if (!current.getAsJsonObject().has(name)) {
                return "";
            }
            current = current.getAsJsonObject().get(name);
        }
        return current != null ? current.getAsString() : "";
    }

    public static JsonElement elementFromPath(JsonElement json, String path) {
        String[] names = path.split("\\.");
        JsonElement current = json;
        for (String name : names) {
            if (!current.isJsonObject() || !current.getAsJsonObject().has(name)) {
                return new JsonObject();
            }
            current = current.getAsJsonObject().get(name);
        }
        return current != null ? current : new JsonObject();
    }

    public String toString() {
        return this.source.toString();
    }

    public JsonObject source() {
        return this.source;
    }

    public static Packet build(JsonObject source, Class<? extends Packet> clazz) {
        Packet packet = Helper.GSON.fromJson((JsonElement)source, clazz);
        packet.source = source;
        return packet;
    }

    public static Packet emtpy() {
        return Packet.build(new JsonObject(), EmptyPacket.class);
    }

    public class Thumbnail {
        public String url;
        public int width;
        public int height;
    }
}

