/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.player;

import com.sedmelluq.discord.lavaplayer.format.AudioDataFormat;
import com.sedmelluq.discord.lavaplayer.format.StandardAudioDataFormats;
import com.sedmelluq.discord.lavaplayer.player.OpusEncoderConfiguration;
import com.sedmelluq.discord.lavaplayer.track.playback.AllocatingAudioFrameBuffer;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBufferFactory;

public class AudioConfiguration {
    public static final int OPUS_QUALITY_MAX = 10;
    private volatile ResamplingQuality resamplingQuality = ResamplingQuality.LOW;
    private volatile int opusEncodingQuality = 10;
    private volatile AudioDataFormat outputFormat = StandardAudioDataFormats.DISCORD_OPUS;
    private volatile boolean filterHotSwapEnabled = false;
    private volatile AudioFrameBufferFactory frameBufferFactory = AllocatingAudioFrameBuffer::new;
    private final OpusEncoderConfiguration opusEncoderConfiguration = new OpusEncoderConfiguration();

    public ResamplingQuality getResamplingQuality() {
        return this.resamplingQuality;
    }

    public AudioConfiguration setResamplingQuality(ResamplingQuality resamplingQuality) {
        this.resamplingQuality = resamplingQuality;
        return this;
    }

    public int getOpusEncodingQuality() {
        return this.opusEncodingQuality;
    }

    public AudioConfiguration setOpusEncodingQuality(int opusEncodingQuality) {
        this.opusEncodingQuality = Math.max(0, Math.min(opusEncodingQuality, 10));
        return this;
    }

    public AudioDataFormat getOutputFormat() {
        return this.outputFormat;
    }

    public AudioConfiguration setOutputFormat(AudioDataFormat outputFormat) {
        this.outputFormat = outputFormat;
        return this;
    }

    public boolean isFilterHotSwapEnabled() {
        return this.filterHotSwapEnabled;
    }

    public AudioConfiguration setFilterHotSwapEnabled(boolean filterHotSwapEnabled) {
        this.filterHotSwapEnabled = filterHotSwapEnabled;
        return this;
    }

    public AudioFrameBufferFactory getFrameBufferFactory() {
        return this.frameBufferFactory;
    }

    public AudioConfiguration setFrameBufferFactory(AudioFrameBufferFactory frameBufferFactory) {
        this.frameBufferFactory = frameBufferFactory;
        return this;
    }

    public OpusEncoderConfiguration getOpusEncoderConfiguration() {
        return this.opusEncoderConfiguration;
    }

    public AudioConfiguration setOpusEncoderConfiguration(OpusEncoderConfiguration other) {
        this.opusEncoderConfiguration.copyFrom(other);
        return this;
    }

    public AudioConfiguration copy() {
        return new AudioConfiguration().setResamplingQuality(this.resamplingQuality).setOpusEncodingQuality(this.opusEncodingQuality).setOutputFormat(this.outputFormat).setFilterHotSwapEnabled(this.filterHotSwapEnabled).setFrameBufferFactory(this.frameBufferFactory).setOpusEncoderConfiguration(this.opusEncoderConfiguration);
    }

    public static enum ResamplingQuality {
        HIGHEST,
        HIGH,
        MEDIUM,
        LOW;

    }
}

