/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.youtube;

import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterfaceManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YoutubeAccessTokenTracker {
    private static final Logger log = LoggerFactory.getLogger(YoutubeAccessTokenTracker.class);
    private static final String AUTH_SCRIPT_REGEX = "<script id=\"base-js\" src=\"(.*?)\" nonce=\".*?\"></script>";
    private static final String IDENTITY_REGEX = "\\{clientId:\"(.+?)\",\\n?.+?:\"(.+?)\"";
    private static final Pattern authScriptPattern = Pattern.compile("<script id=\"base-js\" src=\"(.*?)\" nonce=\".*?\"></script>");
    private static final Pattern identityPattern = Pattern.compile("\\{clientId:\"(.+?)\",\\n?.+?:\"(.+?)\"");
    private static final String TOKEN_FETCH_CONTEXT_ATTRIBUTE = "yt-raw";
    private static final long MASTER_TOKEN_REFRESH_INTERVAL = TimeUnit.DAYS.toMillis(7L);
    private static final long DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL = TimeUnit.HOURS.toMillis(1L);
    private static final long VISITOR_ID_REFRESH_INTERVAL = TimeUnit.MINUTES.toMillis(10L);
    private final Object tokenLock = new Object();
    private final HttpInterfaceManager httpInterfaceManager;
    private final String email;
    private final String password;
    private String masterToken;
    private String accessToken;
    private String visitorId;
    private long lastMasterTokenUpdate;
    private long lastAccessTokenUpdate;
    private long lastVisitorIdUpdate;
    private long accessTokenRefreshInterval = DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL;
    private boolean loggedAgeRestrictionsWarning = false;
    private boolean masterTokenFromTV = false;
    private volatile CachedAuthScript cachedAuthScript = null;

    public YoutubeAccessTokenTracker(HttpInterfaceManager httpInterfaceManager, String email, String password) {
        this.httpInterfaceManager = httpInterfaceManager;
        this.email = email;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMasterToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (DataFormatTools.isNullOrEmpty(this.email) && DataFormatTools.isNullOrEmpty(this.password)) {
                if (!this.loggedAgeRestrictionsWarning) {
                    log.warn("YouTube auth tokens can't be retrieved because email and password is unset in YoutubeAudioSourceManager, age restricted videos may throw exceptions.");
                    this.loggedAgeRestrictionsWarning = true;
                }
                return;
            }
            if (this.loggedAgeRestrictionsWarning) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastMasterTokenUpdate < MASTER_TOKEN_REFRESH_INTERVAL) {
                log.debug("YouTube master token was recently updated, not updating again right away.");
                return;
            }
            this.lastMasterTokenUpdate = now;
            log.info("Updating YouTube master token (current is {}).", (Object)this.masterToken);
            CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(100L);
                    this.masterToken = this.fetchMasterToken();
                    log.info("Updating YouTube master token succeeded, new token is {}.", (Object)this.masterToken);
                }
                catch (Exception e) {
                    log.error("YouTube master token update failed.", e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAccessToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (DataFormatTools.isNullOrEmpty(this.email) && DataFormatTools.isNullOrEmpty(this.password)) {
                if (!this.loggedAgeRestrictionsWarning) {
                    log.warn("YouTube auth tokens can't be retrieved because email and password is unset in YoutubeAudioSourceManager, age restricted videos may throw exceptions.");
                    this.loggedAgeRestrictionsWarning = true;
                }
                return;
            }
            if (DataFormatTools.isNullOrEmpty(this.masterToken) && this.loggedAgeRestrictionsWarning) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastAccessTokenUpdate < this.accessTokenRefreshInterval) {
                log.debug("YouTube access token was recently updated, not updating again right away.");
                return;
            }
            this.lastAccessTokenUpdate = now;
            log.info("Updating YouTube access token (current is {}).", (Object)this.accessToken);
            try {
                this.accessToken = this.fetchAccessToken();
                log.info("Updating YouTube access token succeeded, new token is {}, next update will be after {} seconds.", (Object)this.accessToken, (Object)TimeUnit.MILLISECONDS.toSeconds(this.accessTokenRefreshInterval));
            }
            catch (Exception e) {
                log.error("YouTube access token update failed.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateVisitorId() {
        Object object = this.tokenLock;
        synchronized (object) {
            long now = System.currentTimeMillis();
            if (now - this.lastVisitorIdUpdate < VISITOR_ID_REFRESH_INTERVAL) {
                log.debug("YouTube visitor id was recently updated, not updating again right away.");
                return this.visitorId;
            }
            this.lastVisitorIdUpdate = now;
            log.info("Updating YouTube visitor id (current is {}).", (Object)this.visitorId);
            try {
                this.visitorId = this.fetchVisitorId();
                log.info("Updating YouTube visitor id succeeded, new one is {}, next update will be after {} seconds.", (Object)this.visitorId, (Object)TimeUnit.MILLISECONDS.toSeconds(VISITOR_ID_REFRESH_INTERVAL));
            }
            catch (Exception e) {
                log.error("YouTube visitor id update failed.", e);
            }
            return this.visitorId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMasterToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.masterToken == null) {
                this.updateMasterToken();
            }
            return this.masterToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVisitorId() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.visitorId == null) {
                this.updateVisitorId();
            }
            return this.visitorId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAccessToken() {
        Object object = this.tokenLock;
        synchronized (object) {
            if (this.accessToken == null) {
                this.updateAccessToken();
            }
            return this.accessToken;
        }
    }

    public boolean isTokenFetchContext(HttpClientContext context) {
        return context.getAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE) == Boolean.TRUE;
    }

    private String fetchMasterToken() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, true);
            String string = this.requestMasterToken(httpInterface);
            return string;
        }
    }

    private String fetchAccessToken() throws IOException {
        try (HttpInterface httpInterface = this.httpInterfaceManager.getInterface();){
            httpInterface.getContext().setAttribute(TOKEN_FETCH_CONTEXT_ATTRIBUTE, true);
            String string = this.requestAccessToken(httpInterface);
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    private String fetchVisitorId() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String requestMasterToken(HttpInterface httpInterface) throws IOException {
        HttpPost masterTokenPost = new HttpPost("https://youtube.minerea.su/login");
        StringEntity masterTokenPayload = new StringEntity(String.format("{\"email\":\"%s\",\"password\":\"%s\"}", this.email, this.password));
        masterTokenPost.setEntity(masterTokenPayload);
        try (CloseableHttpResponse masterTokenResponse = httpInterface.execute(masterTokenPost);){
            String responseText = EntityUtils.toString(masterTokenResponse.getEntity(), StandardCharsets.UTF_8);
            JsonBrowser jsonBrowser = JsonBrowser.parse(responseText);
            if (masterTokenResponse.getStatusLine().getStatusCode() == 400) {
                this.loggedAgeRestrictionsWarning = true;
            }
            HttpClientTools.assertSuccessWithContent(masterTokenResponse, "login account response [" + jsonBrowser.get("exception").safeText() + "]");
            if (jsonBrowser.get("tv").asBoolean(false)) {
                this.masterTokenFromTV = true;
                String string = jsonBrowser.get("refresh_token").text();
                return string;
            }
            String services = jsonBrowser.get("services").text();
            if (!jsonBrowser.get("continueUrl").isNull()) {
                String string = this.continueUrl(httpInterface, jsonBrowser);
                return string;
            }
            if (!services.contains("android") || !services.contains("youtube")) {
                this.createAndroidAccount(httpInterface, jsonBrowser);
            }
            String string = jsonBrowser.get("aas_et").text();
            return string;
        }
    }

    private String requestAccessToken(HttpInterface httpInterface) throws IOException {
        if (this.masterTokenFromTV) {
            if (this.cachedAuthScript == null) {
                this.fetchTVScript(httpInterface);
            }
            HttpPost post = new HttpPost("https://www.youtube.com/o/oauth2/token");
            post.setEntity(new StringEntity(String.format("{\"client_id\":\"%s\",\"client_secret\":\"%s\",\"refresh_token\":\"%s\",\"grant_type\":\"refresh_token\"}", this.cachedAuthScript.clientId, this.cachedAuthScript.clientSecret, this.masterToken), "UTF-8"));
            try (CloseableHttpResponse response = httpInterface.execute(post);){
                HttpClientTools.assertSuccessWithContent(response, "access token tv response");
                String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
                JsonBrowser responseJson = JsonBrowser.parse(responseText);
                this.accessTokenRefreshInterval = TimeUnit.SECONDS.toMillis(responseJson.get("expires_in").asLong(DEFAULT_ACCESS_TOKEN_REFRESH_INTERVAL));
                String string = responseJson.get("access_token").text();
                return string;
            }
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add(new BasicNameValuePair("app", "com.google.android.youtube"));
        params.add(new BasicNameValuePair("client_sig", "24bb24c05e47e0aefa68a58a766179d9b613a600"));
        params.add(new BasicNameValuePair("google_play_services_version", "214516005"));
        params.add(new BasicNameValuePair("service", "oauth2:https://www.googleapis.com/auth/youtube"));
        params.add(new BasicNameValuePair("Token", this.masterToken));
        HttpPost post = new HttpPost(this.buildUri("https://android.googleapis.com/auth", params));
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "access token android response");
            Map<String, String> map = DataFormatTools.convertToMapLayout(EntityUtils.toString(response.getEntity()));
            this.accessTokenRefreshInterval = TimeUnit.SECONDS.toMillis(Long.parseLong(map.get("ExpiresInDurationSec")));
            String string = map.get("Auth");
            return string;
        }
    }

    private void createAndroidAccount(HttpInterface httpInterface, JsonBrowser jsonBrowser) throws IOException {
        log.info("Account {} doesn't have an Android or YouTube profile, creating new one...", (Object)jsonBrowser.get("email").text());
        HttpPost post = new HttpPost("https://youtube.minerea.su/checkin");
        StringEntity payload = new StringEntity(String.format("{\"email\":\"%s\",\"password\":\"%s\"}", this.email, this.password));
        post.setEntity(payload);
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "creating android profile response");
        }
    }

    /*
     * Exception decompiling
     */
    private String continueUrl(HttpInterface httpInterface, JsonBrowser jsonBrowser) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String exchangeOAuth2Token(HttpInterface httpInterface, CloseableHttpResponse response) throws IOException {
        for (Header header : response.getAllHeaders()) {
            if (!header.getName().contains("Set-Cookie") || !header.getValue().contains("oauth_token")) continue;
            String oauthToken = DataFormatTools.extractBetween(header.toString(), "oauth_token=", ";");
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
            params.add(new BasicNameValuePair("Token", oauthToken));
            params.add(new BasicNameValuePair("ACCESS_TOKEN", "1"));
            params.add(new BasicNameValuePair("service", "ac2dm"));
            HttpPost post = new HttpPost(this.buildUri("https://android.googleapis.com/auth", params));
            try (CloseableHttpResponse exchangeResponse = httpInterface.execute(post);){
                HttpClientTools.assertSuccessWithContent(exchangeResponse, "exchange oauth2 token response");
                Map<String, String> map = DataFormatTools.convertToMapLayout(EntityUtils.toString(exchangeResponse.getEntity()));
                String string = map.get("Token");
                return string;
            }
        }
        log.warn("First auth method failed, trying second one...");
        return this.requestAuthCode(httpInterface, this.fetchTVScript(httpInterface));
    }

    private CachedAuthScript fetchTVScript(HttpInterface httpInterface) throws IOException {
        HttpGet get = new HttpGet("https://www.youtube.com/tv");
        get.setHeader("User-Agent", "Mozilla/5.0 (ChromiumStylePlatform) Cobalt/Version");
        try (CloseableHttpResponse response = httpInterface.execute(get);){
            HttpClientTools.assertSuccessWithContent(response, "youtube tv page response");
            String responseText = EntityUtils.toString(response.getEntity());
            Matcher authScript = authScriptPattern.matcher(responseText);
            if (!authScript.find()) {
                throw ExceptionTools.throwWithDebugInfo(log, null, "no base-js found", "html", responseText);
            }
            CachedAuthScript cachedAuthScript = this.extractIdentity(httpInterface, authScript.group(1));
            return cachedAuthScript;
        }
    }

    private CachedAuthScript extractIdentity(HttpInterface httpInterface, String scriptUrl) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute(new HttpGet("https://www.youtube.com" + scriptUrl));){
            HttpClientTools.assertSuccessWithContent(response, "tv script response");
            String responseText = EntityUtils.toString(response.getEntity());
            Matcher identity = identityPattern.matcher(responseText);
            if (!identity.find()) {
                throw ExceptionTools.throwWithDebugInfo(log, null, "no identity in base-js found", "js", responseText);
            }
            CachedAuthScript cachedAuthScript = this.cachedAuthScript = new CachedAuthScript(identity.group(1), identity.group(2));
            return cachedAuthScript;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String requestAuthCode(HttpInterface httpInterface, CachedAuthScript script) throws IOException {
        HttpPost post = new HttpPost("https://www.youtube.com/o/oauth2/device/code");
        post.setEntity(new StringEntity(String.format("{\"client_id\":\"%s\",\"device_id\":\"%s\",\"scope\":\"http://gdata.youtube.com https://www.googleapis.com/auth/youtube-paid-content\",\"model_name\":\"ytlr::\"}", script.clientId, UUID.randomUUID()), "UTF-8"));
        try (CloseableHttpResponse response = httpInterface.execute(post);){
            HttpClientTools.assertSuccessWithContent(response, "auth code response");
            String responseText = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            JsonBrowser responseJson = JsonBrowser.parse(responseText);
            String string = this.waitForAuth(httpInterface, responseJson, script);
            return string;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    private String waitForAuth(HttpInterface httpInterface, JsonBrowser json, CachedAuthScript script) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI buildUri(String url, List<NameValuePair> params) {
        try {
            return new URIBuilder(url).addParameters(params).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected static class CachedAuthScript {
        public final String clientId;
        public final String clientSecret;

        public CachedAuthScript(String clientId, String clientSecret) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
        }
    }
}

