/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.tools.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.commons.io.input.CountingInputStream;

public class MessageInput {
    private final CountingInputStream countingInputStream;
    private final DataInputStream dataInputStream;
    private int messageSize;
    private int messageFlags;

    public MessageInput(InputStream inputStream) {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.dataInputStream = new DataInputStream(inputStream);
    }

    public DataInput nextMessage() throws IOException {
        int value = this.dataInputStream.readInt();
        this.messageFlags = (int)(((long)value & 0xC0000000L) >> 30);
        this.messageSize = value & 0x3FFFFFFF;
        if (this.messageSize == 0) {
            return null;
        }
        return new DataInputStream(new BoundedInputStream(this.countingInputStream, this.messageSize));
    }

    public int getMessageFlags() {
        return this.messageFlags;
    }

    public void skipRemainingBytes() throws IOException {
        long count = this.countingInputStream.resetByteCount();
        if (count < (long)this.messageSize) {
            IOUtils.skipFully(this.dataInputStream, (long)this.messageSize - count);
        }
        this.messageSize = 0;
    }
}

