/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.lava.extensions.youtuberotator;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeHttpContextFilter;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpClientBuilder;
import com.sedmelluq.discord.lavaplayer.tools.http.ExtendedHttpConfigurable;
import com.sedmelluq.discord.lavaplayer.tools.http.HttpContextFilter;
import com.sedmelluq.discord.lavaplayer.tools.http.SimpleHttpClientConnectionManager;
import com.sedmelluq.lava.extensions.youtuberotator.YoutubeIpRotatorFilter;
import com.sedmelluq.lava.extensions.youtuberotator.YoutubeIpRotatorRetryHandler;
import com.sedmelluq.lava.extensions.youtuberotator.planner.AbstractRoutePlanner;
import java.util.ArrayList;
import java.util.List;

public class YoutubeIpRotatorSetup {
    private static final int DEFAULT_RETRY_LIMIT = 4;
    private static final YoutubeHttpContextFilter DEFAULT_DELEGATE = new YoutubeHttpContextFilter();
    private static final YoutubeIpRotatorRetryHandler RETRY_HANDLER = new YoutubeIpRotatorRetryHandler();
    private final AbstractRoutePlanner routePlanner;
    private final List<ExtendedHttpConfigurable> mainConfiguration;
    private final List<ExtendedHttpConfigurable> searchConfiguration;
    private int retryLimit = 4;
    private HttpContextFilter mainDelegate = DEFAULT_DELEGATE;
    private HttpContextFilter searchDelegate = null;

    public YoutubeIpRotatorSetup(AbstractRoutePlanner routePlanner) {
        this.routePlanner = routePlanner;
        this.mainConfiguration = new ArrayList<ExtendedHttpConfigurable>();
        this.searchConfiguration = new ArrayList<ExtendedHttpConfigurable>();
    }

    public YoutubeIpRotatorSetup forConfiguration(ExtendedHttpConfigurable configurable, boolean isSearch) {
        if (isSearch) {
            this.searchConfiguration.add(configurable);
        } else {
            this.mainConfiguration.add(configurable);
        }
        return this;
    }

    public YoutubeIpRotatorSetup forSource(YoutubeAudioSourceManager sourceManager) {
        this.forConfiguration(sourceManager.getMainHttpConfiguration(), false);
        this.forConfiguration(sourceManager.getSearchHttpConfiguration(), true);
        this.forConfiguration(sourceManager.getSearchMusicHttpConfiguration(), true);
        DEFAULT_DELEGATE.setTokenTracker(sourceManager.getAccessTokenTracker());
        return this;
    }

    public YoutubeIpRotatorSetup forManager(AudioPlayerManager playerManager) {
        YoutubeAudioSourceManager sourceManager = playerManager.source(YoutubeAudioSourceManager.class);
        if (sourceManager != null) {
            this.forSource(sourceManager);
        }
        return this;
    }

    public YoutubeIpRotatorSetup withRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
        return this;
    }

    public YoutubeIpRotatorSetup withMainDelegateFilter(HttpContextFilter filter) {
        this.mainDelegate = filter;
        return this;
    }

    public YoutubeIpRotatorSetup withSearchDelegateFilter(HttpContextFilter filter) {
        this.searchDelegate = filter;
        return this;
    }

    public void setup() {
        this.apply(this.mainConfiguration, new YoutubeIpRotatorFilter(this.mainDelegate, false, this.routePlanner, this.retryLimit));
        this.apply(this.searchConfiguration, new YoutubeIpRotatorFilter(this.searchDelegate, true, this.routePlanner, this.retryLimit));
    }

    protected void apply(List<ExtendedHttpConfigurable> configurables, YoutubeIpRotatorFilter filter) {
        for (ExtendedHttpConfigurable configurable : configurables) {
            configurable.configureBuilder(builder -> ((ExtendedHttpClientBuilder)builder).setConnectionManagerFactory(SimpleHttpClientConnectionManager::new));
            configurable.configureBuilder(it -> {
                it.setRoutePlanner(this.routePlanner);
                it.setRetryHandler(RETRY_HANDLER);
                it.evictExpiredConnections();
            });
            configurable.setHttpContextFilter(filter);
        }
    }
}

