/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core;

import discord4j.common.LogUtil;
import discord4j.common.store.action.read.ReadActions;
import discord4j.common.util.Snowflake;
import discord4j.core.CoreResources;
import discord4j.core.DiscordClient;
import discord4j.core.GatewayResources;
import discord4j.core.event.EventDispatcher;
import discord4j.core.event.ReactiveEventAdapter;
import discord4j.core.event.domain.Event;
import discord4j.core.object.GuildTemplate;
import discord4j.core.object.Invite;
import discord4j.core.object.Region;
import discord4j.core.object.ScheduledEventUser;
import discord4j.core.object.automod.AutoModRule;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.GuildSticker;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.presence.ClientPresence;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.retriever.EntityRetriever;
import discord4j.core.spec.GuildCreateMono;
import discord4j.core.spec.GuildCreateSpec;
import discord4j.core.spec.UserEditMono;
import discord4j.core.spec.UserEditSpec;
import discord4j.core.spec.legacy.LegacyGuildCreateSpec;
import discord4j.core.spec.legacy.LegacyUserEditSpec;
import discord4j.core.util.ValidationUtil;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildUpdateData;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.RegionData;
import discord4j.discordjson.json.RoleDataFields;
import discord4j.discordjson.json.TemplateData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.RequestGuildMembers;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.GatewayClient;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.rest.RestClient;
import discord4j.voice.LocalVoiceConnectionRegistry;
import discord4j.voice.VoiceConnectionFactory;
import discord4j.voice.VoiceConnectionRegistry;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class GatewayDiscordClient
implements EntityRetriever {
    private static final Logger log = Loggers.getLogger(GatewayDiscordClient.class);
    private final DiscordClient discordClient;
    private final GatewayResources gatewayResources;
    private final Mono<Void> onDisconnect;
    private final GatewayClientGroup gatewayClientGroup;
    private final VoiceConnectionFactory voiceConnectionFactory;
    private final VoiceConnectionRegistry voiceConnectionRegistry;
    private final EntityRetriever entityRetriever;
    private final Set<String> completingChunkNonces;

    public GatewayDiscordClient(DiscordClient discordClient, GatewayResources gatewayResources, Mono<Void> onDisconnect, GatewayClientGroup gatewayClientGroup, VoiceConnectionFactory voiceConnectionFactory, EntityRetrievalStrategy entityRetrievalStrategy, Set<String> completingChunkNonces) {
        this.discordClient = discordClient;
        this.gatewayResources = gatewayResources;
        this.onDisconnect = onDisconnect;
        this.gatewayClientGroup = gatewayClientGroup;
        this.voiceConnectionFactory = voiceConnectionFactory;
        this.voiceConnectionRegistry = new LocalVoiceConnectionRegistry();
        this.entityRetriever = (EntityRetriever)entityRetrievalStrategy.apply(this);
        this.completingChunkNonces = completingChunkNonces;
    }

    public DiscordClient rest() {
        return this.discordClient;
    }

    public CoreResources getCoreResources() {
        return this.discordClient.getCoreResources();
    }

    public GatewayResources getGatewayResources() {
        return this.gatewayResources;
    }

    public EventDispatcher getEventDispatcher() {
        return this.gatewayResources.getEventDispatcher();
    }

    public Optional<GatewayClient> getGatewayClient(int shardId) {
        return this.gatewayClientGroup.find(shardId);
    }

    public GatewayClientGroup getGatewayClientGroup() {
        return this.gatewayClientGroup;
    }

    public VoiceConnectionFactory getVoiceConnectionFactory() {
        return this.voiceConnectionFactory;
    }

    public VoiceConnectionRegistry getVoiceConnectionRegistry() {
        return this.voiceConnectionRegistry;
    }

    public RestClient getRestClient() {
        return this.rest();
    }

    public Mono<Webhook> getWebhookById(Snowflake webhookId) {
        return this.getRestClient().getWebhookService().getWebhook(webhookId.asLong()).map(data -> new Webhook(this, (WebhookData)data));
    }

    public Mono<Webhook> getWebhookByIdWithToken(Snowflake webhookId, String token) {
        return this.getRestClient().getWebhookService().getWebhookWithToken(webhookId.asLong(), token).map(data -> new Webhook(this, (WebhookData)data));
    }

    public Mono<ApplicationInfo> getApplicationInfo() {
        return this.getRestClient().getApplicationService().getCurrentApplicationInfo().map(data -> new ApplicationInfo(this, (ApplicationInfoData)data));
    }

    public Flux<User> getUsers() {
        return Flux.from(this.gatewayResources.getStore().execute(ReadActions.getUsers())).map(data -> new User(this, (UserData)data));
    }

    public Flux<Region> getRegions() {
        return this.getRestClient().getVoiceService().getVoiceRegions().map(data -> new Region(this, (RegionData)data));
    }

    public Mono<GuildTemplate> getTemplateByCode(String templateCode) {
        return this.getRestClient().getTemplateService().getTemplate(templateCode).map(data -> new GuildTemplate(this, (TemplateData)data));
    }

    public Snowflake getSelfId() {
        return this.getCoreResources().getSelfId();
    }

    @Deprecated
    public Mono<Guild> createGuild(Consumer<? super LegacyGuildCreateSpec> spec) {
        return Mono.defer(() -> {
            LegacyGuildCreateSpec mutatedSpec = new LegacyGuildCreateSpec();
            spec.accept(mutatedSpec);
            return this.getRestClient().getGuildService().createGuild(mutatedSpec.asRequest());
        }).map(data -> new Guild(this, this.toGuildData((GuildUpdateData)data)));
    }

    public GuildCreateMono createGuild(String name, Region region) {
        return GuildCreateMono.of(name, region, this);
    }

    public Mono<Guild> createGuild(GuildCreateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getRestClient().getGuildService().createGuild(spec.asRequest())).map(data -> new Guild(this, this.toGuildData((GuildUpdateData)data)));
    }

    private GuildData toGuildData(GuildUpdateData guild) {
        return GuildData.builder().from(guild).roles(guild.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(guild.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).channels(Collections.emptyList()).members(Collections.emptyList()).joinedAt(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now())).large(false).memberCount(1).build();
    }

    public Mono<Void> updatePresence(ClientPresence clientPresence) {
        return this.gatewayClientGroup.multicast(GatewayPayload.statusUpdate(clientPresence.getStatusUpdate()));
    }

    public Mono<Void> updatePresence(ClientPresence clientPresence, int shardId) {
        return this.gatewayClientGroup.unicast(ShardGatewayPayload.statusUpdate(clientPresence.getStatusUpdate(), shardId));
    }

    public Mono<Invite> getInvite(String inviteCode) {
        return this.getRestClient().getInviteService().getInvite(inviteCode).map(data -> new Invite(this, (InviteData)data));
    }

    public Mono<Invite> getInvite(String inviteCode, boolean withCounts, boolean withExpiration, @Nullable Snowflake guildScheduledEventId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("with_counts", withCounts);
        queryParams.put("with_expiration", withExpiration);
        if (guildScheduledEventId != null) {
            queryParams.put("guild_scheduled_event_id", guildScheduledEventId.asString());
        }
        return this.getRestClient().getInviteService().getInvite(inviteCode, queryParams).map(data -> new Invite(this, (InviteData)data));
    }

    @Deprecated
    public Mono<User> edit(Consumer<? super LegacyUserEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyUserEditSpec mutatedSpec = new LegacyUserEditSpec();
            spec.accept(mutatedSpec);
            return this.getRestClient().getUserService().modifyCurrentUser(mutatedSpec.asRequest());
        }).map(data -> new User(this, (UserData)data));
    }

    public UserEditMono edit() {
        return UserEditMono.of(this);
    }

    public Mono<User> edit(UserEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getRestClient().getUserService().modifyCurrentUser(spec.asRequest())).map(data -> new User(this, (UserData)data));
    }

    public Mono<Void> logout() {
        return this.gatewayClientGroup.logout();
    }

    public Mono<Void> onDisconnect() {
        return this.onDisconnect;
    }

    public <E extends Event> Flux<E> on(Class<E> eventClass) {
        return this.getEventDispatcher().on(eventClass).contextWrite(ctx -> ctx.put("discord4j.gateway", Integer.toHexString(this.hashCode())));
    }

    public <E extends Event, T> Flux<T> on(Class<E> eventClass, Function<E, Publisher<T>> mapper) {
        return this.getEventDispatcher().on(eventClass, mapper).contextWrite(ctx -> ctx.put("discord4j.gateway", Integer.toHexString(this.hashCode())));
    }

    public Flux<Event> on(ReactiveEventAdapter adapter) {
        return this.getEventDispatcher().on(adapter).contextWrite(ctx -> ctx.put("discord4j.gateway", Integer.toHexString(this.hashCode())));
    }

    public Flux<Member> requestMembers(Snowflake guildId) {
        return this.requestMembers(RequestGuildMembers.builder().guildId(guildId.asString()).query("").limit(0).build());
    }

    public Flux<Member> requestMembers(Snowflake guildId, Set<Snowflake> userIds) {
        return Flux.fromIterable(userIds).map(Snowflake::asString).buffer(100).concatMap(userIdBuffer -> this.requestMembers(RequestGuildMembers.builder().guildId(guildId.asString()).userIds((List<String>)userIdBuffer).limit(0).build()));
    }

    public Flux<Member> requestMembers(RequestGuildMembers request) {
        Snowflake guildId = Snowflake.of(request.guildId());
        return this.requestMemberChunks(request).flatMapIterable(chunk -> chunk.members().stream().map(data -> new Member(this, (MemberData)data, guildId.asLong())).collect(Collectors.toList()));
    }

    public Flux<GuildMembersChunk> requestMemberChunks(RequestGuildMembers request) {
        try {
            ValidationUtil.validateRequestGuildMembers(request, Possible.of(this.gatewayResources.getIntents()));
        }
        catch (Throwable t) {
            return Flux.error(t);
        }
        Snowflake guildId = Snowflake.of(request.guildId());
        int shardId = this.gatewayClientGroup.computeShardIndex(guildId);
        String nonce = String.valueOf(System.nanoTime());
        Supplier<Flux> incomingMembers = () -> this.gatewayClientGroup.find(shardId).map(gatewayClient -> gatewayClient.dispatch().ofType(GuildMembersChunk.class).takeUntilOther(this.onDisconnect).filter(chunk -> chunk.nonce().toOptional().map(s2 -> s2.equals(nonce)).orElse(false)).takeUntil(chunk -> chunk.chunkIndex() + 1 == chunk.chunkCount())).orElseThrow(() -> new IllegalStateException("Unable to find gateway client"));
        return Flux.deferContextual(ctx -> this.getGuildById(guildId).then(this.gatewayClientGroup.unicast(ShardGatewayPayload.requestGuildMembers(RequestGuildMembers.builder().from(request).nonce(nonce).build(), shardId)).then(Mono.fromRunnable(() -> {
            if (request.query().toOptional().map(String::isEmpty).orElse(false).booleanValue() && request.limit() == 0) {
                this.completingChunkNonces.add(nonce);
            }
        }))).thenMany(Flux.defer(incomingMembers)).doOnComplete(() -> log.debug(LogUtil.format(ctx, "Member request completed: {}"), request)));
    }

    public EntityRetriever withRetrievalStrategy(EntityRetrievalStrategy retrievalStrategy) {
        return (EntityRetriever)retrievalStrategy.apply(this);
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return this.entityRetriever.getChannelById(channelId);
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return this.entityRetriever.getGuildById(guildId);
    }

    @Override
    public Mono<GuildSticker> getGuildStickerById(Snowflake guildId, Snowflake stickerId) {
        return this.entityRetriever.getGuildStickerById(guildId, stickerId);
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return this.entityRetriever.getGuildEmojiById(guildId, emojiId);
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return this.entityRetriever.getMemberById(guildId, userId);
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return this.entityRetriever.getMessageById(channelId, messageId);
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return this.entityRetriever.getRoleById(guildId, roleId);
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return this.entityRetriever.getUserById(userId);
    }

    @Override
    public Flux<Guild> getGuilds() {
        return this.entityRetriever.getGuilds();
    }

    @Override
    public Mono<User> getSelf() {
        return this.entityRetriever.getSelf();
    }

    @Override
    public Mono<Member> getSelfMember(Snowflake guildId) {
        return this.entityRetriever.getSelfMember(guildId);
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        return this.entityRetriever.getGuildMembers(guildId);
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return this.entityRetriever.getGuildChannels(guildId);
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return this.entityRetriever.getGuildRoles(guildId);
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return this.entityRetriever.getGuildEmojis(guildId);
    }

    @Override
    public Flux<GuildSticker> getGuildStickers(Snowflake guildId) {
        return this.entityRetriever.getGuildStickers(guildId);
    }

    @Override
    public Flux<AutoModRule> getGuildAutoModRules(Snowflake guildId) {
        return this.entityRetriever.getGuildAutoModRules(guildId);
    }

    @Override
    public Mono<ScheduledEvent> getScheduledEventById(Snowflake guildId, Snowflake eventId) {
        return this.entityRetriever.getScheduledEventById(guildId, eventId);
    }

    @Override
    public Flux<ScheduledEvent> getScheduledEvents(Snowflake guildId) {
        return this.entityRetriever.getScheduledEvents(guildId);
    }

    @Override
    public Flux<ScheduledEventUser> getScheduledEventUsers(Snowflake guildId, Snowflake eventId) {
        return this.entityRetriever.getScheduledEventUsers(guildId, eventId);
    }
}

