/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.shard;

import discord4j.core.shard.GatewayClientGroupManager;
import discord4j.discordjson.json.gateway.Dispatch;
import discord4j.gateway.GatewayClient;
import discord4j.gateway.GatewayConnection;
import discord4j.gateway.json.GatewayPayload;
import discord4j.gateway.json.ShardGatewayPayload;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

class SingleGatewayClientGroup
implements GatewayClientGroupManager {
    private final AtomicReference<GatewayClient> client = new AtomicReference();

    SingleGatewayClientGroup() {
    }

    @Override
    public void add(int key, GatewayClient gatewayClient) {
        this.client.set(gatewayClient);
    }

    @Override
    public void remove(int key) {
        this.client.set(null);
    }

    private Optional<GatewayClient> instance() {
        return Optional.ofNullable(this.client.get());
    }

    @Override
    public Optional<GatewayClient> find(int index) {
        return this.instance().map(client -> new RoutableGatewayClient((GatewayClient)client, index));
    }

    @Override
    public int getShardCount() {
        return this.instance().map(GatewayClient::getShardCount).orElseThrow(() -> new IllegalStateException("Missing shard count information"));
    }

    @Override
    public Mono<Void> multicast(GatewayPayload<?> payload) {
        return Mono.defer(() -> Mono.just(this.getShardCount())).flatMapMany(count -> Flux.range(0, count)).flatMap(index -> this.unicast(SingleGatewayClientGroup.makeShardAware(payload, index))).then();
    }

    private static ShardGatewayPayload<?> makeShardAware(GatewayPayload<?> payload, int shardIndex) {
        ShardGatewayPayload shardedPayload;
        if (payload instanceof ShardGatewayPayload && (shardedPayload = (ShardGatewayPayload)payload).getShardIndex() != shardIndex) {
            return new ShardGatewayPayload(payload, shardIndex);
        }
        return new ShardGatewayPayload(payload, shardIndex);
    }

    @Override
    public Mono<Void> unicast(ShardGatewayPayload<?> payload) {
        return Mono.defer(() -> Mono.justOrEmpty(this.instance()).switchIfEmpty(Mono.error(new IllegalStateException("Missing gateway client")))).flatMap(client -> client.send(Mono.just(payload)));
    }

    @Override
    public Mono<Void> logout() {
        return Mono.defer(() -> Mono.justOrEmpty(this.instance())).flatMap(client -> client.close(false));
    }

    private static class RoutableGatewayClient
    implements GatewayClient {
        private final GatewayClient client;
        private final int shardIndex;

        private RoutableGatewayClient(GatewayClient client, int shardIndex) {
            this.client = client;
            this.shardIndex = shardIndex;
        }

        @Override
        public Mono<Void> execute(String gatewayUrl) {
            return this.client.execute(gatewayUrl);
        }

        @Override
        public Mono<Void> close(boolean allowResume) {
            return this.client.close(allowResume);
        }

        @Override
        public Flux<Dispatch> dispatch() {
            return this.client.dispatch();
        }

        @Override
        public Flux<GatewayPayload<?>> receiver() {
            return this.client.receiver();
        }

        @Override
        public <T> Flux<T> receiver(Function<ByteBuf, Publisher<? extends T>> mapper) {
            return this.client.receiver(mapper);
        }

        @Override
        public Mono<Void> send(Publisher<? extends GatewayPayload<?>> publisher) {
            return Flux.from(publisher).doOnNext(payload -> this.sender().next(SingleGatewayClientGroup.makeShardAware(payload, this.shardIndex))).then();
        }

        @Override
        public FluxSink<GatewayPayload<?>> sender() {
            return this.client.sender();
        }

        @Override
        public Mono<Void> sendBuffer(Publisher<ByteBuf> publisher) {
            return this.client.sendBuffer(publisher);
        }

        @Override
        public int getShardCount() {
            return this.client.getShardCount();
        }

        @Override
        public String getSessionId() {
            return this.client.getSessionId();
        }

        @Override
        public int getSequence() {
            return this.client.getSequence();
        }

        @Override
        public Flux<GatewayConnection.State> stateEvents() {
            return this.client.stateEvents();
        }

        @Override
        public Mono<Boolean> isConnected() {
            return this.client.isConnected();
        }

        @Override
        public Duration getResponseTime() {
            return this.client.getResponseTime();
        }
    }
}

