/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildEditSpecGenerator", generator="Immutables")
public final class GuildEditSpec
implements GuildEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Region region_value;
    private final boolean region_absent;
    private final Guild.VerificationLevel verificationLevel_value;
    private final boolean verificationLevel_absent;
    private final Guild.NotificationLevel defaultMessageNotificationsLevel_value;
    private final boolean defaultMessageNotificationsLevel_absent;
    private final Guild.ContentFilterLevel explicitContentFilter_value;
    private final boolean explicitContentFilter_absent;
    private final Snowflake afkChannelId_value;
    private final boolean afkChannelId_absent;
    private final Integer afkTimeout_value;
    private final boolean afkTimeout_absent;
    private final Image icon_value;
    private final boolean icon_absent;
    private final Snowflake ownerId_value;
    private final boolean ownerId_absent;
    private final Image splash_value;
    private final boolean splash_absent;
    private final Image discoverySplash_value;
    private final boolean discoverySplash_absent;
    private final Image banner_value;
    private final boolean banner_absent;
    private final Snowflake systemChannelId_value;
    private final boolean systemChannelId_absent;
    private final Guild.SystemChannelFlag systemChannelFlags_value;
    private final boolean systemChannelFlags_absent;
    private final Snowflake rulesChannelId_value;
    private final boolean rulesChannelId_absent;
    private final Snowflake publicUpdatesChannelId_value;
    private final boolean publicUpdatesChannelId_absent;
    private final Locale preferredLocale_value;
    private final boolean preferredLocale_absent;
    private final List<String> features_value;
    private final boolean features_absent;
    private final String description_value;
    private final boolean description_absent;
    private final Snowflake safetyAlertsChannelId_value;
    private final boolean safetyAlertsChannelId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final GuildEditSpec INSTANCE = GuildEditSpec.validate(new GuildEditSpec());

    private GuildEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible region$impl = Possible.absent();
        Possible verificationLevel$impl = Possible.absent();
        Possible defaultMessageNotificationsLevel$impl = Possible.absent();
        Possible explicitContentFilter$impl = Possible.absent();
        Possible afkChannelId$impl = Possible.absent();
        Possible afkTimeout$impl = Possible.absent();
        Possible icon$impl = Possible.absent();
        Possible ownerId$impl = Possible.absent();
        Possible splash$impl = Possible.absent();
        Possible discoverySplash$impl = Possible.absent();
        Possible banner$impl = Possible.absent();
        Possible systemChannelId$impl = Possible.absent();
        Possible systemChannelFlags$impl = Possible.absent();
        Possible rulesChannelId$impl = Possible.absent();
        Possible publicUpdatesChannelId$impl = Possible.absent();
        Possible preferredLocale$impl = Possible.absent();
        Possible features$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        Possible safetyAlertsChannelId$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.region_value = Possible.flatOpt(region$impl).orElse(null);
        this.region_absent = region$impl.isAbsent();
        this.verificationLevel_value = Possible.flatOpt(verificationLevel$impl).orElse(null);
        this.verificationLevel_absent = verificationLevel$impl.isAbsent();
        this.defaultMessageNotificationsLevel_value = Possible.flatOpt(defaultMessageNotificationsLevel$impl).orElse(null);
        this.defaultMessageNotificationsLevel_absent = defaultMessageNotificationsLevel$impl.isAbsent();
        this.explicitContentFilter_value = Possible.flatOpt(explicitContentFilter$impl).orElse(null);
        this.explicitContentFilter_absent = explicitContentFilter$impl.isAbsent();
        this.afkChannelId_value = Possible.flatOpt(afkChannelId$impl).orElse(null);
        this.afkChannelId_absent = afkChannelId$impl.isAbsent();
        this.afkTimeout_value = afkTimeout$impl.toOptional().orElse(null);
        this.afkTimeout_absent = afkTimeout$impl.isAbsent();
        this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.ownerId_value = ownerId$impl.toOptional().orElse(null);
        this.ownerId_absent = ownerId$impl.isAbsent();
        this.splash_value = Possible.flatOpt(splash$impl).orElse(null);
        this.splash_absent = splash$impl.isAbsent();
        this.discoverySplash_value = Possible.flatOpt(discoverySplash$impl).orElse(null);
        this.discoverySplash_absent = discoverySplash$impl.isAbsent();
        this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.systemChannelId_value = Possible.flatOpt(systemChannelId$impl).orElse(null);
        this.systemChannelId_absent = systemChannelId$impl.isAbsent();
        this.systemChannelFlags_value = systemChannelFlags$impl.toOptional().orElse(null);
        this.systemChannelFlags_absent = systemChannelFlags$impl.isAbsent();
        this.rulesChannelId_value = Possible.flatOpt(rulesChannelId$impl).orElse(null);
        this.rulesChannelId_absent = rulesChannelId$impl.isAbsent();
        this.publicUpdatesChannelId_value = Possible.flatOpt(publicUpdatesChannelId$impl).orElse(null);
        this.publicUpdatesChannelId_absent = publicUpdatesChannelId$impl.isAbsent();
        this.preferredLocale_value = Possible.flatOpt(preferredLocale$impl).orElse(null);
        this.preferredLocale_absent = preferredLocale$impl.isAbsent();
        this.features_value = features$impl.toOptional().orElse(null);
        this.features_absent = features$impl.isAbsent();
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.safetyAlertsChannelId_value = Possible.flatOpt(safetyAlertsChannelId$impl).orElse(null);
        this.safetyAlertsChannelId_absent = safetyAlertsChannelId$impl.isAbsent();
        this.initShim = null;
    }

    private GuildEditSpec(@Nullable String reason, Possible<String> name, Possible<Optional<Region>> region, Possible<Optional<Guild.VerificationLevel>> verificationLevel, Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel, Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter, Possible<Optional<Snowflake>> afkChannelId, Possible<Integer> afkTimeout, Possible<Optional<Image>> icon, Possible<Snowflake> ownerId, Possible<Optional<Image>> splash, Possible<Optional<Image>> discoverySplash, Possible<Optional<Image>> banner, Possible<Optional<Snowflake>> systemChannelId, Possible<Guild.SystemChannelFlag> systemChannelFlags, Possible<Optional<Snowflake>> rulesChannelId, Possible<Optional<Snowflake>> publicUpdatesChannelId, Possible<Optional<Locale>> preferredLocale, Possible<List<String>> features, Possible<Optional<String>> description, Possible<Optional<Snowflake>> safetyAlertsChannelId) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible region$impl = region;
        Possible verificationLevel$impl = verificationLevel;
        Possible defaultMessageNotificationsLevel$impl = defaultMessageNotificationsLevel;
        Possible explicitContentFilter$impl = explicitContentFilter;
        Possible afkChannelId$impl = afkChannelId;
        Possible<Integer> afkTimeout$impl = afkTimeout;
        Possible icon$impl = icon;
        Possible<Snowflake> ownerId$impl = ownerId;
        Possible splash$impl = splash;
        Possible discoverySplash$impl = discoverySplash;
        Possible banner$impl = banner;
        Possible systemChannelId$impl = systemChannelId;
        Possible<Guild.SystemChannelFlag> systemChannelFlags$impl = systemChannelFlags;
        Possible rulesChannelId$impl = rulesChannelId;
        Possible publicUpdatesChannelId$impl = publicUpdatesChannelId;
        Possible preferredLocale$impl = preferredLocale;
        Possible<List<String>> features$impl = features;
        Possible description$impl = description;
        Possible safetyAlertsChannelId$impl = safetyAlertsChannelId;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.region_value = Possible.flatOpt(region$impl).orElse(null);
        this.region_absent = region$impl.isAbsent();
        this.verificationLevel_value = Possible.flatOpt(verificationLevel$impl).orElse(null);
        this.verificationLevel_absent = verificationLevel$impl.isAbsent();
        this.defaultMessageNotificationsLevel_value = Possible.flatOpt(defaultMessageNotificationsLevel$impl).orElse(null);
        this.defaultMessageNotificationsLevel_absent = defaultMessageNotificationsLevel$impl.isAbsent();
        this.explicitContentFilter_value = Possible.flatOpt(explicitContentFilter$impl).orElse(null);
        this.explicitContentFilter_absent = explicitContentFilter$impl.isAbsent();
        this.afkChannelId_value = Possible.flatOpt(afkChannelId$impl).orElse(null);
        this.afkChannelId_absent = afkChannelId$impl.isAbsent();
        this.afkTimeout_value = afkTimeout$impl.toOptional().orElse(null);
        this.afkTimeout_absent = afkTimeout$impl.isAbsent();
        this.icon_value = Possible.flatOpt(icon$impl).orElse(null);
        this.icon_absent = icon$impl.isAbsent();
        this.ownerId_value = ownerId$impl.toOptional().orElse(null);
        this.ownerId_absent = ownerId$impl.isAbsent();
        this.splash_value = Possible.flatOpt(splash$impl).orElse(null);
        this.splash_absent = splash$impl.isAbsent();
        this.discoverySplash_value = Possible.flatOpt(discoverySplash$impl).orElse(null);
        this.discoverySplash_absent = discoverySplash$impl.isAbsent();
        this.banner_value = Possible.flatOpt(banner$impl).orElse(null);
        this.banner_absent = banner$impl.isAbsent();
        this.systemChannelId_value = Possible.flatOpt(systemChannelId$impl).orElse(null);
        this.systemChannelId_absent = systemChannelId$impl.isAbsent();
        this.systemChannelFlags_value = systemChannelFlags$impl.toOptional().orElse(null);
        this.systemChannelFlags_absent = systemChannelFlags$impl.isAbsent();
        this.rulesChannelId_value = Possible.flatOpt(rulesChannelId$impl).orElse(null);
        this.rulesChannelId_absent = rulesChannelId$impl.isAbsent();
        this.publicUpdatesChannelId_value = Possible.flatOpt(publicUpdatesChannelId$impl).orElse(null);
        this.publicUpdatesChannelId_absent = publicUpdatesChannelId$impl.isAbsent();
        this.preferredLocale_value = Possible.flatOpt(preferredLocale$impl).orElse(null);
        this.preferredLocale_absent = preferredLocale$impl.isAbsent();
        this.features_value = features$impl.toOptional().orElse(null);
        this.features_absent = features$impl.isAbsent();
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.safetyAlertsChannelId_value = Possible.flatOpt(safetyAlertsChannelId$impl).orElse(null);
        this.safetyAlertsChannelId_absent = safetyAlertsChannelId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of(this.name_value);
    }

    @Override
    public Possible<Optional<Region>> region() {
        return this.region_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.region_value));
    }

    @Override
    public Possible<Optional<Guild.VerificationLevel>> verificationLevel() {
        return this.verificationLevel_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.verificationLevel_value));
    }

    @Override
    public Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel() {
        return this.defaultMessageNotificationsLevel_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.defaultMessageNotificationsLevel_value));
    }

    @Override
    public Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter() {
        return this.explicitContentFilter_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.explicitContentFilter_value));
    }

    @Override
    public Possible<Optional<Snowflake>> afkChannelId() {
        return this.afkChannelId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.afkChannelId_value));
    }

    @Override
    public Possible<Integer> afkTimeout() {
        return this.afkTimeout_absent ? Possible.absent() : Possible.of(this.afkTimeout_value);
    }

    @Override
    public Possible<Optional<Image>> icon() {
        return this.icon_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.icon_value));
    }

    @Override
    public Possible<Snowflake> ownerId() {
        return this.ownerId_absent ? Possible.absent() : Possible.of(this.ownerId_value);
    }

    @Override
    public Possible<Optional<Image>> splash() {
        return this.splash_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.splash_value));
    }

    @Override
    public Possible<Optional<Image>> discoverySplash() {
        return this.discoverySplash_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.discoverySplash_value));
    }

    @Override
    public Possible<Optional<Image>> banner() {
        return this.banner_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.banner_value));
    }

    @Override
    public Possible<Optional<Snowflake>> systemChannelId() {
        return this.systemChannelId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.systemChannelId_value));
    }

    @Override
    public Possible<Guild.SystemChannelFlag> systemChannelFlags() {
        return this.systemChannelFlags_absent ? Possible.absent() : Possible.of(this.systemChannelFlags_value);
    }

    @Override
    public Possible<Optional<Snowflake>> rulesChannelId() {
        return this.rulesChannelId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.rulesChannelId_value));
    }

    @Override
    public Possible<Optional<Snowflake>> publicUpdatesChannelId() {
        return this.publicUpdatesChannelId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.publicUpdatesChannelId_value));
    }

    @Override
    public Possible<Optional<Locale>> preferredLocale() {
        return this.preferredLocale_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.preferredLocale_value));
    }

    @Override
    public Possible<List<String>> features() {
        return this.features_absent ? Possible.absent() : Possible.of(this.features_value);
    }

    @Override
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    @Override
    public Possible<Optional<Snowflake>> safetyAlertsChannelId() {
        return this.safetyAlertsChannelId_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.safetyAlertsChannelId_value));
    }

    public final GuildEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return GuildEditSpec.validate(new GuildEditSpec(value, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, newValue, this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withName(String value) {
        Possible<String> newValue = Possible.of(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, newValue, this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withRegion(Possible<Optional<Region>> value) {
        Possible<Optional<Region>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), newValue, this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withRegion(@Nullable Region value) {
        Possible<Optional<Region>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), newValue, this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withRegionOrNull(@Nullable Region value) {
        Possible<Optional<Region>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), newValue, this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withVerificationLevel(Possible<Optional<Guild.VerificationLevel>> value) {
        Possible<Optional<Guild.VerificationLevel>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), newValue, this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withVerificationLevel(@Nullable Guild.VerificationLevel value) {
        Possible<Optional<Guild.VerificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), newValue, this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withVerificationLevelOrNull(@Nullable Guild.VerificationLevel value) {
        Possible<Optional<Guild.VerificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), newValue, this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withDefaultMessageNotificationsLevel(Possible<Optional<Guild.NotificationLevel>> value) {
        Possible<Optional<Guild.NotificationLevel>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), newValue, this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withDefaultMessageNotificationsLevel(@Nullable Guild.NotificationLevel value) {
        Possible<Optional<Guild.NotificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), newValue, this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withDefaultMessageNotificationsLevelOrNull(@Nullable Guild.NotificationLevel value) {
        Possible<Optional<Guild.NotificationLevel>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), newValue, this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withExplicitContentFilter(Possible<Optional<Guild.ContentFilterLevel>> value) {
        Possible<Optional<Guild.ContentFilterLevel>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), newValue, this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withExplicitContentFilter(@Nullable Guild.ContentFilterLevel value) {
        Possible<Optional<Guild.ContentFilterLevel>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), newValue, this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withExplicitContentFilterOrNull(@Nullable Guild.ContentFilterLevel value) {
        Possible<Optional<Guild.ContentFilterLevel>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), newValue, this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withAfkChannelId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), newValue, this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withAfkChannelId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), newValue, this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withAfkChannelIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), newValue, this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withAfkTimeout(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), newValue, this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withAfkTimeout(Integer value) {
        Possible<Integer> newValue = Possible.of(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), newValue, this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withIcon(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), newValue, this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withIcon(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), newValue, this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withIconOrNull(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), newValue, this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withOwnerId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), newValue, this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withOwnerId(Snowflake value) {
        Possible<Snowflake> newValue = Possible.of(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), newValue, this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSplash(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), newValue, this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withSplash(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), newValue, this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSplashOrNull(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), newValue, this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withDiscoverySplash(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), newValue, this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withDiscoverySplash(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), newValue, this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withDiscoverySplashOrNull(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), newValue, this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withBanner(Possible<Optional<Image>> value) {
        Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), newValue, this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withBanner(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), newValue, this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withBannerOrNull(@Nullable Image value) {
        Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), newValue, this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSystemChannelId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), newValue, this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withSystemChannelId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), newValue, this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSystemChannelIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), newValue, this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSystemChannelFlags(Possible<Guild.SystemChannelFlag> value) {
        Possible<Guild.SystemChannelFlag> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), newValue, this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSystemChannelFlags(Guild.SystemChannelFlag value) {
        Possible<Guild.SystemChannelFlag> newValue = Possible.of(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), newValue, this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withRulesChannelId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), newValue, this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withRulesChannelId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), newValue, this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withRulesChannelIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), newValue, this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withPublicUpdatesChannelId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), newValue, this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withPublicUpdatesChannelId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), newValue, this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withPublicUpdatesChannelIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), newValue, this.preferredLocale(), this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withPreferredLocale(Possible<Optional<Locale>> value) {
        Possible<Optional<Locale>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), newValue, this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withPreferredLocale(@Nullable Locale value) {
        Possible<Optional<Locale>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), newValue, this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withPreferredLocaleOrNull(@Nullable Locale value) {
        Possible<Optional<Locale>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), newValue, this.features(), this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withFeatures(Possible<List<String>> possible) {
        Possible<List<String>> newValue = Objects.requireNonNull(possible);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), newValue, this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withFeatures(Iterable<String> elements) {
        Possible<List<String>> newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), newValue, this.description(), this.safetyAlertsChannelId()));
    }

    @SafeVarargs
    public final GuildEditSpec withFeatures(String ... elements) {
        Possible<List<String>> newValue = Possible.of(Arrays.asList(elements));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), newValue, this.description(), this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), newValue, this.safetyAlertsChannelId()));
    }

    @Deprecated
    public GuildEditSpec withDescription(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), newValue, this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withDescriptionOrNull(@Nullable String value) {
        Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), newValue, this.safetyAlertsChannelId()));
    }

    public GuildEditSpec withSafetyAlertsChannelId(Possible<Optional<Snowflake>> value) {
        Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), newValue));
    }

    @Deprecated
    public GuildEditSpec withSafetyAlertsChannelId(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), newValue));
    }

    public GuildEditSpec withSafetyAlertsChannelIdOrNull(@Nullable Snowflake value) {
        Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
        return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name(), this.region(), this.verificationLevel(), this.defaultMessageNotificationsLevel(), this.explicitContentFilter(), this.afkChannelId(), this.afkTimeout(), this.icon(), this.ownerId(), this.splash(), this.discoverySplash(), this.banner(), this.systemChannelId(), this.systemChannelFlags(), this.rulesChannelId(), this.publicUpdatesChannelId(), this.preferredLocale(), this.features(), this.description(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildEditSpec && this.equalTo(0, (GuildEditSpec)another);
    }

    private boolean equalTo(int synthetic, GuildEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.region().equals(another.region()) && this.verificationLevel().equals(another.verificationLevel()) && this.defaultMessageNotificationsLevel().equals(another.defaultMessageNotificationsLevel()) && this.explicitContentFilter().equals(another.explicitContentFilter()) && this.afkChannelId().equals(another.afkChannelId()) && this.afkTimeout().equals(another.afkTimeout()) && this.icon().equals(another.icon()) && this.ownerId().equals(another.ownerId()) && this.splash().equals(another.splash()) && this.discoverySplash().equals(another.discoverySplash()) && this.banner().equals(another.banner()) && this.systemChannelId().equals(another.systemChannelId()) && this.systemChannelFlags().equals(another.systemChannelFlags()) && this.rulesChannelId().equals(another.rulesChannelId()) && this.publicUpdatesChannelId().equals(another.publicUpdatesChannelId()) && this.preferredLocale().equals(another.preferredLocale()) && Objects.equals(this.features_value, another.features_value) && this.description().equals(another.description()) && this.safetyAlertsChannelId().equals(another.safetyAlertsChannelId());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name().hashCode();
        h2 += (h2 << 5) + this.region().hashCode();
        h2 += (h2 << 5) + this.verificationLevel().hashCode();
        h2 += (h2 << 5) + this.defaultMessageNotificationsLevel().hashCode();
        h2 += (h2 << 5) + this.explicitContentFilter().hashCode();
        h2 += (h2 << 5) + this.afkChannelId().hashCode();
        h2 += (h2 << 5) + this.afkTimeout().hashCode();
        h2 += (h2 << 5) + this.icon().hashCode();
        h2 += (h2 << 5) + this.ownerId().hashCode();
        h2 += (h2 << 5) + this.splash().hashCode();
        h2 += (h2 << 5) + this.discoverySplash().hashCode();
        h2 += (h2 << 5) + this.banner().hashCode();
        h2 += (h2 << 5) + this.systemChannelId().hashCode();
        h2 += (h2 << 5) + this.systemChannelFlags().hashCode();
        h2 += (h2 << 5) + this.rulesChannelId().hashCode();
        h2 += (h2 << 5) + this.publicUpdatesChannelId().hashCode();
        h2 += (h2 << 5) + this.preferredLocale().hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.features_value);
        h2 += (h2 << 5) + this.description().hashCode();
        h2 += (h2 << 5) + this.safetyAlertsChannelId().hashCode();
        return h2;
    }

    public String toString() {
        return "GuildEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", region=" + this.region().toString() + ", verificationLevel=" + this.verificationLevel().toString() + ", defaultMessageNotificationsLevel=" + this.defaultMessageNotificationsLevel().toString() + ", explicitContentFilter=" + this.explicitContentFilter().toString() + ", afkChannelId=" + this.afkChannelId().toString() + ", afkTimeout=" + this.afkTimeout().toString() + ", icon=" + this.icon().toString() + ", ownerId=" + this.ownerId().toString() + ", splash=" + this.splash().toString() + ", discoverySplash=" + this.discoverySplash().toString() + ", banner=" + this.banner().toString() + ", systemChannelId=" + this.systemChannelId().toString() + ", systemChannelFlags=" + this.systemChannelFlags().toString() + ", rulesChannelId=" + this.rulesChannelId().toString() + ", publicUpdatesChannelId=" + this.publicUpdatesChannelId().toString() + ", preferredLocale=" + this.preferredLocale().toString() + ", features=" + Objects.toString(this.features_value) + ", description=" + this.description().toString() + ", safetyAlertsChannelId=" + this.safetyAlertsChannelId().toString() + "}";
    }

    public static GuildEditSpec create() {
        return INSTANCE;
    }

    private static GuildEditSpec validate(GuildEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static GuildEditSpec copyOf(GuildEditSpecGenerator instance) {
        if (instance instanceof GuildEditSpec) {
            return (GuildEditSpec)instance;
        }
        return GuildEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isRegionPresent() {
        return !this.region_absent;
    }

    public Region regionOrElse(Region defaultValue) {
        return !this.region_absent ? this.region_value : defaultValue;
    }

    public boolean isVerificationLevelPresent() {
        return !this.verificationLevel_absent;
    }

    public Guild.VerificationLevel verificationLevelOrElse(Guild.VerificationLevel defaultValue) {
        return !this.verificationLevel_absent ? this.verificationLevel_value : defaultValue;
    }

    public boolean isDefaultMessageNotificationsLevelPresent() {
        return !this.defaultMessageNotificationsLevel_absent;
    }

    public Guild.NotificationLevel defaultMessageNotificationsLevelOrElse(Guild.NotificationLevel defaultValue) {
        return !this.defaultMessageNotificationsLevel_absent ? this.defaultMessageNotificationsLevel_value : defaultValue;
    }

    public boolean isExplicitContentFilterPresent() {
        return !this.explicitContentFilter_absent;
    }

    public Guild.ContentFilterLevel explicitContentFilterOrElse(Guild.ContentFilterLevel defaultValue) {
        return !this.explicitContentFilter_absent ? this.explicitContentFilter_value : defaultValue;
    }

    public boolean isAfkChannelIdPresent() {
        return !this.afkChannelId_absent;
    }

    public Snowflake afkChannelIdOrElse(Snowflake defaultValue) {
        return !this.afkChannelId_absent ? this.afkChannelId_value : defaultValue;
    }

    public boolean isAfkTimeoutPresent() {
        return !this.afkTimeout_absent;
    }

    public Integer afkTimeoutOrElse(Integer defaultValue) {
        return !this.afkTimeout_absent ? this.afkTimeout_value : defaultValue;
    }

    public boolean isIconPresent() {
        return !this.icon_absent;
    }

    public Image iconOrElse(Image defaultValue) {
        return !this.icon_absent ? this.icon_value : defaultValue;
    }

    public boolean isOwnerIdPresent() {
        return !this.ownerId_absent;
    }

    public Snowflake ownerIdOrElse(Snowflake defaultValue) {
        return !this.ownerId_absent ? this.ownerId_value : defaultValue;
    }

    public boolean isSplashPresent() {
        return !this.splash_absent;
    }

    public Image splashOrElse(Image defaultValue) {
        return !this.splash_absent ? this.splash_value : defaultValue;
    }

    public boolean isDiscoverySplashPresent() {
        return !this.discoverySplash_absent;
    }

    public Image discoverySplashOrElse(Image defaultValue) {
        return !this.discoverySplash_absent ? this.discoverySplash_value : defaultValue;
    }

    public boolean isBannerPresent() {
        return !this.banner_absent;
    }

    public Image bannerOrElse(Image defaultValue) {
        return !this.banner_absent ? this.banner_value : defaultValue;
    }

    public boolean isSystemChannelIdPresent() {
        return !this.systemChannelId_absent;
    }

    public Snowflake systemChannelIdOrElse(Snowflake defaultValue) {
        return !this.systemChannelId_absent ? this.systemChannelId_value : defaultValue;
    }

    public boolean isSystemChannelFlagsPresent() {
        return !this.systemChannelFlags_absent;
    }

    public Guild.SystemChannelFlag systemChannelFlagsOrElse(Guild.SystemChannelFlag defaultValue) {
        return !this.systemChannelFlags_absent ? this.systemChannelFlags_value : defaultValue;
    }

    public boolean isRulesChannelIdPresent() {
        return !this.rulesChannelId_absent;
    }

    public Snowflake rulesChannelIdOrElse(Snowflake defaultValue) {
        return !this.rulesChannelId_absent ? this.rulesChannelId_value : defaultValue;
    }

    public boolean isPublicUpdatesChannelIdPresent() {
        return !this.publicUpdatesChannelId_absent;
    }

    public Snowflake publicUpdatesChannelIdOrElse(Snowflake defaultValue) {
        return !this.publicUpdatesChannelId_absent ? this.publicUpdatesChannelId_value : defaultValue;
    }

    public boolean isPreferredLocalePresent() {
        return !this.preferredLocale_absent;
    }

    public Locale preferredLocaleOrElse(Locale defaultValue) {
        return !this.preferredLocale_absent ? this.preferredLocale_value : defaultValue;
    }

    public boolean isFeaturesPresent() {
        return !this.features_absent;
    }

    public List<String> featuresOrElse(List<String> defaultValue) {
        return !this.features_absent ? this.features_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isSafetyAlertsChannelIdPresent() {
        return !this.safetyAlertsChannelId_absent;
    }

    public Snowflake safetyAlertsChannelIdOrElse(Snowflake defaultValue) {
        return !this.safetyAlertsChannelId_absent ? this.safetyAlertsChannelId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GuildEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Optional<Region>> region_possible = Possible.absent();
        private Possible<Optional<Guild.VerificationLevel>> verificationLevel_possible = Possible.absent();
        private Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel_possible = Possible.absent();
        private Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter_possible = Possible.absent();
        private Possible<Optional<Snowflake>> afkChannelId_possible = Possible.absent();
        private Possible<Integer> afkTimeout_possible = Possible.absent();
        private Possible<Optional<Image>> icon_possible = Possible.absent();
        private Possible<Snowflake> ownerId_possible = Possible.absent();
        private Possible<Optional<Image>> splash_possible = Possible.absent();
        private Possible<Optional<Image>> discoverySplash_possible = Possible.absent();
        private Possible<Optional<Image>> banner_possible = Possible.absent();
        private Possible<Optional<Snowflake>> systemChannelId_possible = Possible.absent();
        private Possible<Guild.SystemChannelFlag> systemChannelFlags_possible = Possible.absent();
        private Possible<Optional<Snowflake>> rulesChannelId_possible = Possible.absent();
        private Possible<Optional<Snowflake>> publicUpdatesChannelId_possible = Possible.absent();
        private Possible<Optional<Locale>> preferredLocale_possible = Possible.absent();
        private List<String> features_list = null;
        private Possible<Optional<String>> description_possible = Possible.absent();
        private Possible<Optional<Snowflake>> safetyAlertsChannelId_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(GuildEditSpec instance) {
            return this.from((GuildEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.region(instance.region());
            this.verificationLevel(instance.verificationLevel());
            this.defaultMessageNotificationsLevel(instance.defaultMessageNotificationsLevel());
            this.explicitContentFilter(instance.explicitContentFilter());
            this.afkChannelId(instance.afkChannelId());
            this.afkTimeout(instance.afkTimeout());
            this.icon(instance.icon());
            this.ownerId(instance.ownerId());
            this.splash(instance.splash());
            this.discoverySplash(instance.discoverySplash());
            this.banner(instance.banner());
            this.systemChannelId(instance.systemChannelId());
            this.systemChannelFlags(instance.systemChannelFlags());
            this.rulesChannelId(instance.rulesChannelId());
            this.publicUpdatesChannelId(instance.publicUpdatesChannelId());
            this.preferredLocale(instance.preferredLocale());
            this.features(instance.features());
            this.description(instance.description());
            this.safetyAlertsChannelId(instance.safetyAlertsChannelId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder region(Possible<Optional<Region>> value) {
            this.region_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder region(@Nullable Region value) {
            this.region_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder regionOrNull(@Nullable Region value) {
            this.region_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder verificationLevel(Possible<Optional<Guild.VerificationLevel>> value) {
            this.verificationLevel_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder verificationLevel(@Nullable Guild.VerificationLevel value) {
            this.verificationLevel_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder verificationLevelOrNull(@Nullable Guild.VerificationLevel value) {
            this.verificationLevel_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder defaultMessageNotificationsLevel(Possible<Optional<Guild.NotificationLevel>> value) {
            this.defaultMessageNotificationsLevel_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder defaultMessageNotificationsLevel(@Nullable Guild.NotificationLevel value) {
            this.defaultMessageNotificationsLevel_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder defaultMessageNotificationsLevelOrNull(@Nullable Guild.NotificationLevel value) {
            this.defaultMessageNotificationsLevel_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder explicitContentFilter(Possible<Optional<Guild.ContentFilterLevel>> value) {
            this.explicitContentFilter_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder explicitContentFilter(@Nullable Guild.ContentFilterLevel value) {
            this.explicitContentFilter_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder explicitContentFilterOrNull(@Nullable Guild.ContentFilterLevel value) {
            this.explicitContentFilter_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afkChannelId(Possible<Optional<Snowflake>> value) {
            this.afkChannelId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder afkChannelId(@Nullable Snowflake value) {
            this.afkChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afkChannelIdOrNull(@Nullable Snowflake value) {
            this.afkChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afkTimeout(Possible<Integer> value) {
            this.afkTimeout_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder afkTimeout(Integer value) {
            this.afkTimeout_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder icon(Possible<Optional<Image>> value) {
            this.icon_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder icon(@Nullable Image value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder iconOrNull(@Nullable Image value) {
            this.icon_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder ownerId(Possible<Snowflake> value) {
            this.ownerId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder ownerId(Snowflake value) {
            this.ownerId_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder splash(Possible<Optional<Image>> value) {
            this.splash_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder splash(@Nullable Image value) {
            this.splash_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder splashOrNull(@Nullable Image value) {
            this.splash_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder discoverySplash(Possible<Optional<Image>> value) {
            this.discoverySplash_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder discoverySplash(@Nullable Image value) {
            this.discoverySplash_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder discoverySplashOrNull(@Nullable Image value) {
            this.discoverySplash_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder banner(Possible<Optional<Image>> value) {
            this.banner_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder banner(@Nullable Image value) {
            this.banner_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder bannerOrNull(@Nullable Image value) {
            this.banner_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder systemChannelId(Possible<Optional<Snowflake>> value) {
            this.systemChannelId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder systemChannelId(@Nullable Snowflake value) {
            this.systemChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder systemChannelIdOrNull(@Nullable Snowflake value) {
            this.systemChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder systemChannelFlags(Possible<Guild.SystemChannelFlag> value) {
            this.systemChannelFlags_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder systemChannelFlags(Guild.SystemChannelFlag value) {
            this.systemChannelFlags_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rulesChannelId(Possible<Optional<Snowflake>> value) {
            this.rulesChannelId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder rulesChannelId(@Nullable Snowflake value) {
            this.rulesChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder rulesChannelIdOrNull(@Nullable Snowflake value) {
            this.rulesChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder publicUpdatesChannelId(Possible<Optional<Snowflake>> value) {
            this.publicUpdatesChannelId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder publicUpdatesChannelId(@Nullable Snowflake value) {
            this.publicUpdatesChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder publicUpdatesChannelIdOrNull(@Nullable Snowflake value) {
            this.publicUpdatesChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder preferredLocale(Possible<Optional<Locale>> value) {
            this.preferredLocale_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder preferredLocale(@Nullable Locale value) {
            this.preferredLocale_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder preferredLocaleOrNull(@Nullable Locale value) {
            this.preferredLocale_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addFeature(String element) {
            this.features_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllFeatures(List<String> elements) {
            this.features_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder features(Possible<List<String>> elements) {
            this.features_list = null;
            elements.toOptional().ifPresent(e -> this.features_getOrCreate().addAll((Collection<String>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder features(List<String> elements) {
            this.features_list = new ArrayList<String>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder features(Iterable<String> elements) {
            this.features_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(Possible<Optional<String>> value) {
            this.description_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder description(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder descriptionOrNull(@Nullable String value) {
            this.description_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder safetyAlertsChannelId(Possible<Optional<Snowflake>> value) {
            this.safetyAlertsChannelId_possible = value;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder safetyAlertsChannelId(@Nullable Snowflake value) {
            this.safetyAlertsChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder safetyAlertsChannelIdOrNull(@Nullable Snowflake value) {
            this.safetyAlertsChannelId_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public GuildEditSpec build() {
            return GuildEditSpec.validate(new GuildEditSpec(this.reason, this.name_build(), this.region_build(), this.verificationLevel_build(), this.defaultMessageNotificationsLevel_build(), this.explicitContentFilter_build(), this.afkChannelId_build(), this.afkTimeout_build(), this.icon_build(), this.ownerId_build(), this.splash_build(), this.discoverySplash_build(), this.banner_build(), this.systemChannelId_build(), this.systemChannelFlags_build(), this.rulesChannelId_build(), this.publicUpdatesChannelId_build(), this.preferredLocale_build(), this.features_build(), this.description_build(), this.safetyAlertsChannelId_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Optional<Region>> region_build() {
            return this.region_possible;
        }

        private Possible<Optional<Guild.VerificationLevel>> verificationLevel_build() {
            return this.verificationLevel_possible;
        }

        private Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel_build() {
            return this.defaultMessageNotificationsLevel_possible;
        }

        private Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter_build() {
            return this.explicitContentFilter_possible;
        }

        private Possible<Optional<Snowflake>> afkChannelId_build() {
            return this.afkChannelId_possible;
        }

        private Possible<Integer> afkTimeout_build() {
            return this.afkTimeout_possible;
        }

        private Possible<Optional<Image>> icon_build() {
            return this.icon_possible;
        }

        private Possible<Snowflake> ownerId_build() {
            return this.ownerId_possible;
        }

        private Possible<Optional<Image>> splash_build() {
            return this.splash_possible;
        }

        private Possible<Optional<Image>> discoverySplash_build() {
            return this.discoverySplash_possible;
        }

        private Possible<Optional<Image>> banner_build() {
            return this.banner_possible;
        }

        private Possible<Optional<Snowflake>> systemChannelId_build() {
            return this.systemChannelId_possible;
        }

        private Possible<Guild.SystemChannelFlag> systemChannelFlags_build() {
            return this.systemChannelFlags_possible;
        }

        private Possible<Optional<Snowflake>> rulesChannelId_build() {
            return this.rulesChannelId_possible;
        }

        private Possible<Optional<Snowflake>> publicUpdatesChannelId_build() {
            return this.publicUpdatesChannelId_possible;
        }

        private Possible<Optional<Locale>> preferredLocale_build() {
            return this.preferredLocale_possible;
        }

        private Possible<List<String>> features_build() {
            return this.features_list == null ? Possible.absent() : Possible.of(this.features_list);
        }

        private List<String> features_getOrCreate() {
            if (this.features_list == null) {
                this.features_list = new ArrayList<String>();
            }
            return this.features_list;
        }

        private Possible<Optional<String>> description_build() {
            return this.description_possible;
        }

        private Possible<Optional<Snowflake>> safetyAlertsChannelId_build() {
            return this.safetyAlertsChannelId_possible;
        }
    }

    @Generated(from="GuildEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

