/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import com.iwebpp.crypto.TweetNaclFast;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import reactor.util.annotation.Nullable;

final class PacketTransformer {
    private static final int RTP_HEADER_LENGTH = 12;
    private static final int EXTENDED_RTP_HEADER_LENGTH = 24;
    private final int ssrc;
    private final TweetNaclFast.SecretBox boxer;
    private char seq = '\u0000';

    PacketTransformer(int ssrc, TweetNaclFast.SecretBox boxer) {
        this.ssrc = ssrc;
        this.boxer = boxer;
    }

    byte[] nextSend(byte[] audio) {
        char c = this.seq;
        this.seq = (char)(c + '\u0001');
        byte[] header = this.getRtpHeader(c);
        byte[] encrypted = this.boxer.box(audio, this.getNonce(header));
        return PacketTransformer.getAudioPacket(header, encrypted);
    }

    @Nullable
    byte[] nextReceive(ByteBuf packet) {
        byte[] header = new byte[12];
        packet.getBytes(0, header);
        int audioOffset = 12 + 4 * (byte)(header[0] & 0xF);
        byte[] encrypted = new byte[packet.readableBytes() - audioOffset];
        packet.getBytes(audioOffset, encrypted);
        packet.release();
        byte[] decrypted = this.boxer.open(encrypted, this.getNonce(header));
        if (decrypted == null) {
            return null;
        }
        byte[] newPacket = new byte[12 + decrypted.length];
        System.arraycopy(header, 0, newPacket, 0, 12);
        System.arraycopy(decrypted, 0, newPacket, audioOffset, decrypted.length);
        return newPacket;
    }

    private byte[] getNonce(byte[] rtpHeader) {
        byte[] nonce = new byte[24];
        System.arraycopy(rtpHeader, 0, nonce, 0, 12);
        return nonce;
    }

    private byte[] getRtpHeader(char seq) {
        return ByteBuffer.allocate(12).put((byte)-128).put((byte)120).putChar(seq).putInt(seq * 960).putInt(this.ssrc).array();
    }

    private static byte[] getAudioPacket(byte[] rtpHeader, byte[] encryptedAudio) {
        byte[] packet = new byte[rtpHeader.length + encryptedAudio.length];
        System.arraycopy(rtpHeader, 0, packet, 0, rtpHeader.length);
        System.arraycopy(encryptedAudio, 0, packet, rtpHeader.length, encryptedAudio.length);
        return packet;
    }
}

