/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.WebhookEditWithTokenSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="WebhookEditWithTokenSpecGenerator", generator="Immutables")
public final class WebhookEditWithTokenSpec
implements WebhookEditWithTokenSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Image avatar_value;
    private final boolean avatar_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final WebhookEditWithTokenSpec INSTANCE = WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec());

    private WebhookEditWithTokenSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible avatar$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    private WebhookEditWithTokenSpec(@Nullable String reason, Possible<String> name, Possible<Image> avatar) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Image> avatar$impl = avatar;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.avatar_value = avatar$impl.toOptional().orElse(null);
        this.avatar_absent = avatar$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of(this.name_value);
    }

    @Override
    public Possible<Image> avatar() {
        return this.avatar_absent ? Possible.absent() : Possible.of(this.avatar_value);
    }

    public final WebhookEditWithTokenSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec(value, this.name(), this.avatar()));
    }

    public WebhookEditWithTokenSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec(this.reason, newValue, this.avatar()));
    }

    public WebhookEditWithTokenSpec withName(String value) {
        Possible<String> newValue = Possible.of(value);
        return WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec(this.reason, newValue, this.avatar()));
    }

    public WebhookEditWithTokenSpec withAvatar(Possible<Image> value) {
        Possible<Image> newValue = Objects.requireNonNull(value);
        return WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec(this.reason, this.name(), newValue));
    }

    public WebhookEditWithTokenSpec withAvatar(Image value) {
        Possible<Image> newValue = Possible.of(value);
        return WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec(this.reason, this.name(), newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof WebhookEditWithTokenSpec && this.equalTo(0, (WebhookEditWithTokenSpec)another);
    }

    private boolean equalTo(int synthetic, WebhookEditWithTokenSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.avatar().equals(another.avatar());
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.reason);
        h2 += (h2 << 5) + this.name().hashCode();
        h2 += (h2 << 5) + this.avatar().hashCode();
        return h2;
    }

    public String toString() {
        return "WebhookEditWithTokenSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", avatar=" + this.avatar().toString() + "}";
    }

    public static WebhookEditWithTokenSpec create() {
        return INSTANCE;
    }

    private static WebhookEditWithTokenSpec validate(WebhookEditWithTokenSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static WebhookEditWithTokenSpec copyOf(WebhookEditWithTokenSpecGenerator instance) {
        if (instance instanceof WebhookEditWithTokenSpec) {
            return (WebhookEditWithTokenSpec)instance;
        }
        return WebhookEditWithTokenSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isAvatarPresent() {
        return !this.avatar_absent;
    }

    public Image avatarOrElse(Image defaultValue) {
        return !this.avatar_absent ? this.avatar_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WebhookEditWithTokenSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Image> avatar_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(WebhookEditWithTokenSpec instance) {
            return this.from((WebhookEditWithTokenSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(WebhookEditWithTokenSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.avatar(instance.avatar());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of(value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatar(Possible<Image> value) {
            this.avatar_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder avatar(Image value) {
            this.avatar_possible = Possible.of(value);
            return this;
        }

        public WebhookEditWithTokenSpec build() {
            return WebhookEditWithTokenSpec.validate(new WebhookEditWithTokenSpec(this.reason, this.name_build(), this.avatar_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Image> avatar_build() {
            return this.avatar_possible;
        }
    }

    @Generated(from="WebhookEditWithTokenSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build WebhookEditWithTokenSpec, attribute initializers form cycle " + attributes;
        }
    }
}

