/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class Utils {
    public static int getFilePosition(String name) {
        if (!name.isEmpty()) {
            File[] files = (File[])Helper.files.clone();
            for (int i1 = 0; i1 < files.length; ++i1) {
                String file = files[i1].getName().toLowerCase();
                if (!file.equals(name)) continue;
                return i1;
            }
        }
        return -1;
    }

    public static int getCustomFilePosition(String name) {
        if (!name.isEmpty()) {
            File[] files = (File[])Helper.customs.clone();
            for (int i1 = 0; i1 < files.length; ++i1) {
                String file = files[i1].getName().toLowerCase();
                if (!file.equals(name)) continue;
                return i1;
            }
        }
        return -1;
    }

    public static ArrayList<String> getFilelistAsList(String regex) {
        String name;
        int i1;
        regex = ((String)regex).contains("*") ? ((String)regex).replaceAll("*", "(.*)") : "(.*)" + (String)regex + "(.*)";
        ArrayList<String> list = new ArrayList<String>();
        File[] files = (File[])Helper.files.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            try {
                if (!name.matches((String)regex)) continue;
                list.add(name);
                continue;
            }
            catch (Exception e) {
                ConsoleRunner.println(e.getMessage());
            }
        }
        files = (File[])Helper.customs.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            try {
                if (!name.matches((String)regex)) continue;
                list.add(name);
                continue;
            }
            catch (Exception e) {
                ConsoleRunner.println(e.getMessage());
            }
        }
        return list;
    }

    public static String getFilelistAsString(String regex) {
        String name;
        int i1;
        int count = 0;
        StringBuilder playlist = new StringBuilder();
        regex = ((String)regex).contains("*") ? ((String)regex).replaceAll("*", "(.*)") : "(.*)" + (String)regex + "(.*)";
        File[] files = (File[])Helper.files.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            if (name == null || name.isEmpty() || !name.matches((String)regex)) continue;
            playlist.append(name + "\n");
            ++count;
        }
        files = (File[])Helper.customs.clone();
        for (i1 = 0; i1 < files.length; ++i1) {
            name = files[i1].getName().toLowerCase();
            if (name == null || name.isEmpty() || !name.matches((String)regex)) continue;
            playlist.append(name + "\n");
            ++count;
        }
        playlist.append("\nThere are " + count + " matches for " + (String)regex);
        return playlist.toString();
    }

    public static void shuffleFilelist(File[] files) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i1 = files.length - 1; i1 > 0; --i1) {
            int index = ((Random)random).nextInt(i1 + 1);
            File a = files[index];
            files[index] = files[i1];
            files[i1] = a;
        }
    }

    public static void refreshFilelist() {
        File file = new File(Config.PLAYLIST_PATH);
        File custom = new File(Config.PLAYLIST_PATH_CUSTOM);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().toLowerCase().endsWith(".mp4");
            }
        };
        Helper.files = file.exists() ? (file.isDirectory() ? file.listFiles(filter) : (file.isFile() ? new File[]{file} : new File[0])) : new File[0];
        Helper.customs = custom.exists() ? (custom.isDirectory() ? custom.listFiles(filter) : (custom.isFile() ? new File[]{custom} : new File[0])) : new File[0];
    }
}

