/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.message;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.message.MessageEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MessageDeleteEvent
extends MessageEvent {
    private final long messageId;
    private final long channelId;
    @Nullable
    private final Long guildId;
    @Nullable
    private final Message message;

    public MessageDeleteEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long messageId, long channelId, @Nullable Long guildId, @Nullable Message message) {
        super(gateway, shardInfo);
        this.messageId = messageId;
        this.channelId = channelId;
        this.guildId = guildId;
        this.message = message;
    }

    public Snowflake getMessageId() {
        return Snowflake.of(this.messageId);
    }

    public Optional<Message> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Snowflake getChannelId() {
        return Snowflake.of(this.channelId);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public String toString() {
        return "MessageDeleteEvent{messageId=" + this.messageId + ", channelId=" + this.channelId + ", message=" + this.message + '}';
    }
}

