/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.json.ComponentData;
import discord4j.discordjson.json.ImmutableComponentData;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class Button
extends ActionComponent {
    public static Button primary(String customId, String label) {
        return Button.of(Style.PRIMARY, customId, null, label, null);
    }

    public static Button primary(String customId, ReactionEmoji emoji) {
        return Button.of(Style.PRIMARY, customId, emoji, null, null);
    }

    public static Button primary(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.PRIMARY, customId, emoji, label, null);
    }

    public static Button secondary(String customId, String label) {
        return Button.of(Style.SECONDARY, customId, null, label, null);
    }

    public static Button secondary(String customId, ReactionEmoji emoji) {
        return Button.of(Style.SECONDARY, customId, emoji, null, null);
    }

    public static Button secondary(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.SECONDARY, customId, emoji, label, null);
    }

    public static Button success(String customId, String label) {
        return Button.of(Style.SUCCESS, customId, null, label, null);
    }

    public static Button success(String customId, ReactionEmoji emoji) {
        return Button.of(Style.SUCCESS, customId, emoji, null, null);
    }

    public static Button success(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.SUCCESS, customId, emoji, label, null);
    }

    public static Button danger(String customId, String label) {
        return Button.of(Style.DANGER, customId, null, label, null);
    }

    public static Button danger(String customId, ReactionEmoji emoji) {
        return Button.of(Style.DANGER, customId, emoji, null, null);
    }

    public static Button danger(String customId, ReactionEmoji emoji, String label) {
        return Button.of(Style.DANGER, customId, emoji, label, null);
    }

    public static Button link(String url, String label) {
        return Button.of(Style.LINK, null, null, label, url);
    }

    public static Button link(String url, ReactionEmoji emoji) {
        return Button.of(Style.LINK, null, emoji, null, url);
    }

    public static Button link(String url, ReactionEmoji emoji, String label) {
        return Button.of(Style.LINK, null, emoji, label, url);
    }

    private static Button of(Style style, @Nullable String customId, @Nullable ReactionEmoji emoji, @Nullable String label, @Nullable String url) {
        ImmutableComponentData.Builder builder = ComponentData.builder().type(MessageComponent.Type.BUTTON.getValue()).style(style.getValue());
        if (customId != null) {
            builder.customId(customId);
        }
        if (emoji != null) {
            builder.emoji(emoji.asEmojiData());
        }
        if (label != null) {
            builder.label(label);
        }
        if (url != null) {
            builder.url(url);
        }
        return new Button(builder.build());
    }

    Button(ComponentData data) {
        super(data);
    }

    public Style getStyle() {
        return this.getData().style().toOptional().map(Style::of).orElseThrow(IllegalStateException::new);
    }

    public Optional<String> getLabel() {
        return this.getData().label().toOptional();
    }

    public Optional<ReactionEmoji> getEmoji() {
        return this.getData().emoji().toOptional().map(ReactionEmoji::of);
    }

    public Optional<String> getCustomId() {
        return this.getData().customId().toOptional();
    }

    public Optional<String> getUrl() {
        return this.getData().url().toOptional();
    }

    public boolean isDisabled() {
        return this.getData().disabled().toOptional().orElse(false);
    }

    public Button disabled() {
        return new Button(ComponentData.builder().from(this.getData()).disabled(true).build());
    }

    public Button disabled(boolean value) {
        return new Button(ComponentData.builder().from(this.getData()).disabled(value).build());
    }

    public static enum Style {
        UNKNOWN(-1),
        PRIMARY(1),
        SECONDARY(2),
        SUCCESS(3),
        DANGER(4),
        LINK(5);

        private final int value;

        private Style(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Style of(int value) {
            switch (value) {
                case 1: {
                    return PRIMARY;
                }
                case 2: {
                    return SECONDARY;
                }
                case 3: {
                    return SUCCESS;
                }
                case 4: {
                    return DANGER;
                }
                case 5: {
                    return LINK;
                }
            }
            return UNKNOWN;
        }
    }
}

