/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console;

import com.gmail.berndivader.streamserver.console.command.Command;
import com.gmail.berndivader.streamserver.console.command.Commands;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;

public class ConsoleRunner {
    static Scanner keyboard;
    static PrintStream console;
    static Commands commands;
    public static boolean forceExit;
    public static boolean exit;
    public static ConsoleRunner instance;

    public ConsoleRunner() {
        instance = this;
        exit = false;
        while (!exit) {
            ConsoleRunner.printReady();
            String input = keyboard.nextLine();
            if (input == null || !input.startsWith(".")) continue;
            String[] parse = input.split(" ", 2);
            if (parse.length == 1) {
                parse = new String[]{parse[0], ""};
            }
            String command = parse[0].toLowerCase();
            String[] args = new String[]{parse[1]};
            Command cmd = commands.getCommand(command.substring(1));
            if (cmd == null) continue;
            cmd.execute(args);
        }
        keyboard.close();
    }

    public static void printErr(String string) {
        console.printf("\u001b[0;1m%s\n>", string);
    }

    public static void println(String string) {
        console.printf("%s\n>", string);
    }

    public static void print(String string) {
        console.printf("%s", string);
    }

    public static void printReady() {
        console.printf("\n%s", ">");
    }

    static {
        try {
            commands = new Commands();
        }
        catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }
        keyboard = new Scanner(System.in);
        console = System.out;
    }
}

