/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Region;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.BaseCategorizableChannel;
import discord4j.core.spec.VoiceChannelEditSpec;
import discord4j.core.spec.VoiceChannelJoinSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.store.api.util.LongLongTuple2;
import discord4j.voice.VoiceConnection;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VoiceChannel
extends BaseCategorizableChannel {
    public VoiceChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public int getBitrate() {
        return this.getData().bitrate().toOptional().orElseThrow(IllegalStateException::new);
    }

    public int getUserLimit() {
        return this.getData().userLimit().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Region.Id getRtcRegion() {
        return Possible.flatOpt(this.getData().rtcRegion()).map(Region.Id::of).orElse(Region.Id.AUTOMATIC);
    }

    public Mode getVideoQualityMode() {
        return this.getData().videoQualityMode().toOptional().map(Mode::of).orElse(Mode.AUTO);
    }

    public Mono<VoiceChannel> edit(Consumer<? super VoiceChannelEditSpec> spec) {
        return Mono.defer(() -> {
            VoiceChannelEditSpec mutatedSpec = new VoiceChannelEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(VoiceChannel.class);
    }

    public Flux<VoiceState> getVoiceStates() {
        return this.getClient().getGatewayResources().getStateView().getVoiceStateStore().findInRange(LongLongTuple2.of(this.getGuildId().asLong(), Long.MIN_VALUE), LongLongTuple2.of(this.getGuildId().asLong(), Long.MAX_VALUE)).filter(data -> data.channelId().map(Id::asString).map(this.getId().asString()::equals).orElse(false)).map(data -> new VoiceState(this.getClient(), (VoiceStateData)data));
    }

    public Mono<VoiceConnection> join(Consumer<? super VoiceChannelJoinSpec> spec) {
        return Mono.defer(() -> {
            VoiceChannelJoinSpec mutatedSpec = new VoiceChannelJoinSpec(this.getClient(), this);
            spec.accept(mutatedSpec);
            return mutatedSpec.asRequest();
        });
    }

    public Mono<Void> sendConnectVoiceState(boolean selfMute, boolean selfDeaf) {
        GatewayClientGroup clientGroup = this.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(this.getGuildId());
        return clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate(VoiceStateUpdate.builder().guildId(this.getGuildId().asString()).channelId(this.getId().asString()).selfMute(selfMute).selfDeaf(selfDeaf).build(), shardId));
    }

    public Mono<Void> sendDisconnectVoiceState() {
        GatewayClientGroup clientGroup = this.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(this.getGuildId());
        return clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate(VoiceStateUpdate.builder().guildId(this.getGuildId().asString()).selfMute(false).selfDeaf(false).build(), shardId));
    }

    public Mono<Boolean> isMemberConnected(Snowflake memberId) {
        return this.getVoiceStates().map(VoiceState::getUserId).any(memberId::equals);
    }

    public Mono<VoiceConnection> getVoiceConnection() {
        return this.getGuild().flatMap(Guild::getVoiceConnection).filterWhen(voiceConnection -> voiceConnection.getChannelId().map(channelId -> channelId.equals(this.getId())));
    }

    @Override
    public String toString() {
        return "VoiceChannel{} " + super.toString();
    }

    public static enum Mode {
        UNKNOWN(-1),
        AUTO(1),
        FULL(2);

        private final int value;

        private Mode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Mode of(int value) {
            switch (value) {
                case 1: {
                    return AUTO;
                }
                case 2: {
                    return FULL;
                }
            }
            return UNKNOWN;
        }
    }
}

