/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.presence;

import discord4j.core.object.presence.Activity;
import discord4j.core.object.presence.Status;
import discord4j.discordjson.json.ActivityUpdateRequest;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.gateway.StatusUpdate;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Presence {
    private final PresenceData data;

    public static StatusUpdate online() {
        return StatusUpdate.builder().status(Status.ONLINE.getValue()).game(Optional.empty()).afk(false).since(Optional.empty()).build();
    }

    public static StatusUpdate online(ActivityUpdateRequest activity) {
        return StatusUpdate.builder().status(Status.ONLINE.getValue()).game(activity).afk(false).since(Optional.empty()).build();
    }

    public static StatusUpdate doNotDisturb() {
        return StatusUpdate.builder().status(Status.DO_NOT_DISTURB.getValue()).game(Optional.empty()).afk(false).since(Optional.empty()).build();
    }

    public static StatusUpdate doNotDisturb(ActivityUpdateRequest activity) {
        return StatusUpdate.builder().status(Status.DO_NOT_DISTURB.getValue()).game(activity).afk(false).since(Optional.empty()).build();
    }

    public static StatusUpdate idle() {
        return StatusUpdate.builder().status(Status.IDLE.getValue()).game(Optional.empty()).afk(true).since(Instant.now().toEpochMilli()).build();
    }

    public static StatusUpdate idle(ActivityUpdateRequest activity) {
        return StatusUpdate.builder().status(Status.IDLE.getValue()).game(activity).afk(true).since(Instant.now().toEpochMilli()).build();
    }

    public static StatusUpdate invisible() {
        return StatusUpdate.builder().status(Status.INVISIBLE.getValue()).game(Optional.empty()).afk(false).since(Optional.empty()).build();
    }

    public Presence(PresenceData data) {
        this.data = data;
    }

    public Status getStatus() {
        return Status.of(this.data.status());
    }

    public Optional<Status> getStatus(Status.Platform platform) {
        switch (platform) {
            case DESKTOP: {
                return this.data.clientStatus().desktop().toOptional().map(Status::of);
            }
            case MOBILE: {
                return this.data.clientStatus().mobile().toOptional().map(Status::of);
            }
            case WEB: {
                return this.data.clientStatus().web().toOptional().map(Status::of);
            }
        }
        throw new AssertionError();
    }

    public Optional<Activity> getActivity() {
        return this.data.activities().stream().map(Activity::new).findFirst();
    }

    public List<Activity> getActivities() {
        return this.data.activities().stream().map(Activity::new).collect(Collectors.toList());
    }

    public StatusUpdate asStatusUpdate() {
        return StatusUpdate.builder().status(this.data.status()).game(this.data.activities().stream().findFirst().map(activity -> ActivityUpdateRequest.builder().from((discord4j.discordjson.json.Activity)activity).url(Possible.flatOpt(activity.url())).build())).afk(this.data.status().equals(Status.IDLE.getValue())).since(this.data.status().equals(Status.IDLE.getValue()) ? Optional.of(Instant.now().toEpochMilli()) : Optional.empty()).build();
    }

    public String toString() {
        return "Presence{data=" + this.data + '}';
    }
}

