/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.retriever;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetriever;
import discord4j.core.state.StateView;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.UserData;
import discord4j.gateway.intent.Intent;
import discord4j.store.api.util.LongLongTuple2;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StoreEntityRetriever
implements EntityRetriever {
    private final GatewayDiscordClient gateway;
    private final StateView stateView;

    public StoreEntityRetriever(GatewayDiscordClient gateway) {
        this.gateway = gateway;
        this.stateView = gateway.getGatewayResources().getStateView();
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return this.stateView.getChannelStore().find(channelId.asLong()).map(data -> EntityUtil.getChannel(this.gateway, data));
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return this.stateView.getGuildStore().find(guildId.asLong()).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return this.stateView.getGuildEmojiStore().find(emojiId.asLong()).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, guildId.asLong()));
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return this.stateView.getMemberStore().find(LongLongTuple2.of(guildId.asLong(), userId.asLong())).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).switchIfEmpty(this.gateway.requestMembers(guildId, Collections.singleton(userId)).filter(member -> member.getId().equals(userId)).next());
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return this.stateView.getMessageStore().find(messageId.asLong()).map(data -> new Message(this.gateway, (MessageData)data));
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return this.stateView.getRoleStore().find(roleId.asLong()).map(data -> new Role(this.gateway, (RoleData)data, guildId.asLong()));
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return this.stateView.getUserStore().find(userId.asLong()).map(data -> new User(this.gateway, (UserData)data));
    }

    @Override
    public Flux<Guild> getGuilds() {
        return this.stateView.getGuildStore().values().map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<User> getSelf() {
        return this.getUserById(this.gateway.getSelfId());
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        return this.stateView.getGuildStore().find(guildId.asLong()).filterWhen(guild -> Mono.justOrEmpty(this.gateway.getGatewayResources().getIntents().toOptional()).filter(intents -> intents.contains((Object)Intent.GUILDS)).flatMap(intents -> new Guild(this.gateway, (GuildData)guild).getVoiceStates().count()).map(count -> (long)guild.memberCount() - count == 1L).defaultIfEmpty(true)).flatMapMany(guildData -> Flux.fromIterable(guildData.members()).flatMap(memberId -> this.stateView.getMemberStore().find(LongLongTuple2.of(guildId.asLong(), Snowflake.asLong(memberId)))).map(member -> new Member(this.gateway, (MemberData)member, guildId.asLong()))).switchIfEmpty(this.gateway.requestMembers(guildId)).onErrorResume(TimeoutException.class, t -> Mono.empty());
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return this.stateView.getGuildStore().find(guildId.asLong()).flatMapMany(guildData -> Flux.fromIterable(guildData.channels()).flatMap(channelId -> this.stateView.getChannelStore().find(Snowflake.asLong(channelId))).map(channelData -> EntityUtil.getChannel(this.gateway, channelData)).cast(GuildChannel.class));
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return this.stateView.getGuildStore().find(guildId.asLong()).flatMapMany(guildData -> Flux.fromIterable(guildData.roles()).flatMap(roleId -> this.stateView.getRoleStore().find(Snowflake.asLong(roleId))).map(roleData -> new Role(this.gateway, (RoleData)roleData, guildId.asLong())));
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return this.stateView.getGuildStore().find(guildId.asLong()).flatMapMany(guildData -> Flux.fromIterable(guildData.emojis()).flatMap(emojiId -> this.stateView.getGuildEmojiStore().find(Snowflake.asLong(emojiId))).map(emojiData -> new GuildEmoji(this.gateway, (EmojiData)emojiData, guildId.asLong())));
    }
}

