/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.RoleCreateRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import reactor.util.annotation.Nullable;

public class RoleCreateSpec
implements AuditSpec<RoleCreateRequest> {
    private String name;
    private Long permissions;
    private Integer color;
    private Boolean hoist;
    private Boolean mentionable;
    @Nullable
    private String reason;

    public RoleCreateSpec setName(String name) {
        this.name = name;
        return this;
    }

    public RoleCreateSpec setPermissions(PermissionSet permissions) {
        this.permissions = permissions.getRawValue();
        return this;
    }

    public RoleCreateSpec setColor(Color color) {
        this.color = color.getRGB();
        return this;
    }

    public RoleCreateSpec setHoist(boolean hoist) {
        this.hoist = hoist;
        return this;
    }

    public RoleCreateSpec setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
        return this;
    }

    public RoleCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public RoleCreateRequest asRequest() {
        return RoleCreateRequest.builder().name(this.name == null ? Possible.absent() : Possible.of(this.name)).permissions(this.permissions == null ? Possible.absent() : Possible.of(this.permissions)).color(this.color == null ? Possible.absent() : Possible.of(this.color)).hoist(this.hoist == null ? Possible.absent() : Possible.of(this.hoist)).mentionable(this.mentionable == null ? Possible.absent() : Possible.of(this.mentionable)).build();
    }
}

