/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.DMCreateRequest;
import discord4j.discordjson.json.UserData;
import discord4j.rest.RestClient;
import reactor.core.publisher.Mono;

public class RestUser {
    private final RestClient restClient;
    private final long id;

    private RestUser(RestClient restClient, long id) {
        this.restClient = restClient;
        this.id = id;
    }

    public static RestUser create(RestClient restClient, Snowflake id) {
        return new RestUser(restClient, id.asLong());
    }

    static RestUser create(RestClient restClient, long id) {
        return new RestUser(restClient, id);
    }

    public Snowflake getId() {
        return Snowflake.of(this.id);
    }

    public Mono<UserData> getData() {
        return this.restClient.getUserService().getUser(this.id);
    }

    public final Mono<ChannelData> getPrivateChannel() {
        return this.restClient.getUserService().createDM(DMCreateRequest.builder().recipientId(Snowflake.asString(this.id)).build());
    }
}

