/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.request;

import discord4j.common.operator.RateLimitOperator;
import discord4j.rest.request.GlobalRateLimiter;
import java.time.Duration;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.Logger;
import reactor.util.Loggers;

public class BucketGlobalRateLimiter
implements GlobalRateLimiter {
    private static final Logger log = Loggers.getLogger(BucketGlobalRateLimiter.class);
    private final RateLimitOperator<Integer> operator;
    private volatile long limitedUntil = 0L;

    BucketGlobalRateLimiter(int capacity, Duration refillPeriod, Scheduler delayScheduler) {
        this.operator = new RateLimitOperator(capacity, refillPeriod, delayScheduler);
    }

    public static BucketGlobalRateLimiter create() {
        return new BucketGlobalRateLimiter(50, Duration.ofSeconds(1L), Schedulers.parallel());
    }

    public static BucketGlobalRateLimiter create(int capacity, Duration refillPeriod, Scheduler delayScheduler) {
        return new BucketGlobalRateLimiter(capacity, refillPeriod, delayScheduler);
    }

    @Override
    public Mono<Void> rateLimitFor(Duration duration) {
        return Mono.fromRunnable(() -> {
            this.limitedUntil = System.nanoTime() + duration.toNanos();
        });
    }

    @Override
    public Mono<Duration> getRemaining() {
        return Mono.fromCallable(() -> Duration.ofNanos(this.limitedUntil - System.nanoTime()));
    }

    @Override
    public <T> Flux<T> withLimiter(Publisher<T> stage) {
        return Mono.just(0).transform(this.operator).then(this.getRemaining()).filter(delay -> delay.getSeconds() > 0L).flatMapMany(delay -> {
            log.trace("[{}] Delaying for {}", Integer.toHexString(this.hashCode()), delay);
            return Mono.delay(delay).flatMapMany(tick -> Flux.from(stage));
        }).switchIfEmpty(stage);
    }
}

