/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.console.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.ConsoleCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.console.ConsoleRunner;
import com.gmail.berndivader.streamserver.console.command.Command;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

@ConsoleCommand(name="dlp", usage="Download media. Usage: dlp --url <http source> or use --help")
public class DownloadMediaFile
extends Command {
    @Override
    public boolean execute(String[] args) {
        File directory = new File(Config.DL_MUSIC_PATH);
        if (!directory.exists()) {
            directory.mkdir();
        }
        if (directory.isFile()) {
            return false;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.directory(directory);
        builder.command("yt-dlp", "--ignore-errors", "--extract-audio", "--format", "bestaudio", "--audio-format", "mp3", "--audio-quality", "160K", "--output", "%(title)s.%(ext)s", "--restrict-filenames", "--no-playlist");
        String[] temp = args[0].split(" --");
        for (int i = 0; i < temp.length; ++i) {
            if (!temp[i].startsWith("--")) {
                temp[i] = "--".concat(temp[i]);
            }
            String[] parse = temp[i].split(" ", 2);
            for (int j = 0; j < parse.length; ++j) {
                if (parse[j].equals("--url")) continue;
                builder.command().add(parse[j]);
            }
        }
        try {
            Process process = builder.start();
            InterruptHandler handler = new InterruptHandler(process);
            Future<Boolean> future = Helper.executor.submit(handler);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                while (process.isAlive() && !future.isDone()) {
                    String out = reader.readLine();
                    if (out == null) continue;
                    ConsoleRunner.println(out);
                }
            }
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            try {
                try {
                    reader.lines().forEach(line -> ConsoleRunner.printErr(line));
                }
                catch (Exception e) {
                    ConsoleRunner.printErr(e.getMessage());
                }
            }
            finally {
                reader.close();
            }
            if (process.isAlive()) {
                process.destroy();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private class InterruptHandler
    implements Callable<Boolean> {
        private final Process process;
        private boolean run = true;

        public InterruptHandler(Process process) {
            this.process = process;
        }

        @Override
        public Boolean call() throws Exception {
            String input = "";
            while (this.run && this.process.isAlive()) {
                int size;
                byte[] bytes;
                if (System.in.available() <= 0 || (input = new String(bytes = new byte[System.in.available()]).substring(0, (size = System.in.read(bytes)) - 1)) == null || !input.equals(".q")) continue;
                this.run = false;
            }
            if (this.process.isAlive()) {
                this.process.destroy();
            }
            return true;
        }
    }
}

