/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.gateway.ShardInfo;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class MemberUpdateEvent
extends GuildEvent {
    private final long guildId;
    private final long memberId;
    @Nullable
    private final Member old;
    private final List<Long> currentRoles;
    @Nullable
    private final String currentNickname;
    @Nullable
    private final String currentJoinedAt;
    @Nullable
    private final String currentPremiumSince;
    @Nullable
    private final Boolean currentPending;

    public MemberUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, long memberId, @Nullable Member old, List<Long> currentRoles, @Nullable String currentNickname, @Nullable String currentJoinedAt, @Nullable String currentPremiumSince, @Nullable Boolean currentPending) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.memberId = memberId;
        this.old = old;
        this.currentRoles = currentRoles;
        this.currentNickname = currentNickname;
        this.currentJoinedAt = currentJoinedAt;
        this.currentPremiumSince = currentPremiumSince;
        this.currentPending = currentPending;
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Snowflake getMemberId() {
        return Snowflake.of(this.memberId);
    }

    public Mono<Member> getMember() {
        return this.getClient().getMemberById(this.getGuildId(), this.getMemberId());
    }

    public Optional<Member> getOld() {
        return Optional.ofNullable(this.old);
    }

    public Set<Snowflake> getCurrentRoles() {
        return this.currentRoles.stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Optional<String> getCurrentNickname() {
        return Optional.ofNullable(this.currentNickname);
    }

    @Nullable
    public Instant getJoinTime() {
        if (this.currentJoinedAt == null) {
            return null;
        }
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.currentJoinedAt, Instant::from);
    }

    public Optional<Instant> getCurrentPremiumSince() {
        return Optional.ofNullable(this.currentPremiumSince).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public boolean isCurrentPending() {
        return Optional.ofNullable(this.currentPending).orElse(false);
    }

    public String toString() {
        return "MemberUpdateEvent{guildId=" + this.guildId + ", memberId=" + this.memberId + ", old=" + this.old + ", currentRoles=" + this.currentRoles + ", currentNickname='" + this.currentNickname + '\'' + ", currentJoinedAt='" + this.currentJoinedAt + '\'' + ", currentPremiumSince='" + this.currentPremiumSince + '\'' + ", currentPending='" + this.currentPending + '\'' + '}';
    }
}

