/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.audit;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.audit.ActionType;
import discord4j.core.object.audit.AuditLogChange;
import discord4j.core.object.audit.ChangeKey;
import discord4j.core.object.audit.OptionKey;
import discord4j.core.object.entity.Entity;
import discord4j.core.util.AuditLogUtil;
import discord4j.discordjson.json.AuditLogEntryData;
import java.util.Optional;

public class AuditLogEntry
implements Entity {
    public static final int MAX_REASON_LENGTH = 512;
    private final GatewayDiscordClient gateway;
    private final AuditLogEntryData data;

    public AuditLogEntry(GatewayDiscordClient gateway, AuditLogEntryData data) {
        this.gateway = gateway;
        this.data = data;
    }

    public AuditLogEntryData getData() {
        return this.data;
    }

    public Optional<Snowflake> getTargetId() {
        return this.data.targetId().filter(it -> !it.equals("0")).map(Snowflake::of);
    }

    public Snowflake getResponsibleUserId() {
        return this.getUserId().orElse(null);
    }

    public Optional<Snowflake> getUserId() {
        return this.data.userId().map(Snowflake::of);
    }

    public Optional<String> getReason() {
        return this.data.reason().toOptional();
    }

    public ActionType getActionType() {
        return ActionType.of(this.data.actionType());
    }

    public <T> Optional<AuditLogChange<T>> getChange(ChangeKey<T> changeKey) {
        return this.data.changes().toOptional().map(list -> list.stream().collect(AuditLogUtil.changeCollector())).map(map -> (AuditLogChange)map.get(changeKey.getName())).map(AuditLogEntry::cast);
    }

    private static <T> AuditLogChange<T> cast(AuditLogChange<?> strategy) {
        return strategy;
    }

    public <T> Optional<T> getOption(OptionKey<T> optionKey) {
        return this.data.options().toOptional().map(AuditLogUtil::createOptionMap).map(map -> map.get(optionKey.getField())).map(AuditLogEntry::cast);
    }

    private static <T> T cast(Object value) {
        return (T)value;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of(this.data.id());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "AuditLogEntry{data=" + this.data + '}';
    }
}

