/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.presence.Presence;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.BanQuerySpec;
import discord4j.core.spec.GuildMemberEditSpec;
import discord4j.core.util.OrderUtil;
import discord4j.core.util.PermissionUtil;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ImmutableRequestGuildMembers;
import discord4j.discordjson.json.gateway.RequestGuildMembers;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.PermissionSet;
import discord4j.store.api.util.LongLongTuple2;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.math.MathFlux;
import reactor.util.annotation.Nullable;

public final class Member
extends User {
    private final MemberData data;
    private final long guildId;

    public Member(GatewayDiscordClient gateway, MemberData data, long guildId) {
        super(gateway, data.user());
        this.data = Objects.requireNonNull(data);
        this.guildId = guildId;
    }

    @Override
    public Mono<Member> asMember(Snowflake guildId) {
        return Mono.just(this).filter(member -> member.getGuildId().equals(guildId)).switchIfEmpty(super.asMember(guildId));
    }

    public MemberData getMemberData() {
        return this.data;
    }

    public Set<Snowflake> getRoleIds() {
        return this.data.roles().stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Flux<Role> getRoles() {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Flux<Role> getRoles(EntityRetrievalStrategy retrievalStrategy) {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Mono<Role> getHighestRole() {
        return MathFlux.max(Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().getRoleById(this.getGuildId(), (Snowflake)id)), OrderUtil.ROLE_ORDER);
    }

    public Mono<Role> getHighestRole(EntityRetrievalStrategy retrievalStrategy) {
        return MathFlux.max(Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id)), OrderUtil.ROLE_ORDER);
    }

    @Nullable
    public Instant getJoinTime() {
        return this.data.joinedAt().map(it -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)it, Instant::from)).orElse(null);
    }

    public Optional<Instant> getPremiumTime() {
        return Possible.flatOpt(this.data.premiumSince()).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Snowflake getGuildId() {
        return Snowflake.of(this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public String getDisplayName() {
        return this.getNickname().orElse(this.getUsername());
    }

    public Optional<String> getNickname() {
        return Possible.flatOpt(this.data.nick());
    }

    public String getNicknameMention() {
        return "<@!" + this.getId().asString() + ">";
    }

    public Mono<VoiceState> getVoiceState() {
        return this.getClient().getGatewayResources().getStateView().getVoiceStateStore().find(LongLongTuple2.of(this.getGuildId().asLong(), this.getId().asLong())).map(bean -> new VoiceState(this.getClient(), (VoiceStateData)bean));
    }

    public Mono<Presence> getPresence() {
        if (this.getClient().getSelfId().equals(this.getId())) {
            return Mono.defer(() -> {
                ImmutableRequestGuildMembers request = RequestGuildMembers.builder().guildId(this.getGuildId().asString()).addUserId(this.getId().asString()).presences(true).limit(1).build();
                return this.getClient().requestMemberChunks(request).singleOrEmpty().flatMap(chunk -> Mono.justOrEmpty(chunk.presences().toOptional()).flatMapIterable(list -> list).next().map(Presence::new)).onErrorResume(IllegalArgumentException.class, err -> Mono.empty());
            });
        }
        return this.getClient().getGatewayResources().getStateView().getPresenceStore().find(LongLongTuple2.of(this.getGuildId().asLong(), this.getId().asLong())).map(Presence::new);
    }

    public boolean isPending() {
        return this.data.pending().toOptional().orElse(false);
    }

    public Mono<Void> kick() {
        return this.kick(null);
    }

    public Mono<Void> kick(@Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().removeGuildMember(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    public Mono<Void> ban(Consumer<? super BanQuerySpec> spec) {
        return Mono.defer(() -> {
            BanQuerySpec mutatedSpec = new BanQuerySpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getGuildService().createGuildBan(this.getGuildId().asLong(), this.getId().asLong(), (Map<String, Object>)mutatedSpec.asRequest(), mutatedSpec.getReason());
        });
    }

    public Mono<Void> unban() {
        return this.unban(null);
    }

    public Mono<Void> unban(@Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().removeGuildBan(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    public Mono<Void> addRole(Snowflake roleId) {
        return this.addRole(roleId, null);
    }

    public Mono<Void> addRole(Snowflake roleId, @Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().addGuildMemberRole(this.guildId, this.getId().asLong(), roleId.asLong(), reason);
    }

    public Mono<Void> removeRole(Snowflake roleId) {
        return this.removeRole(roleId, null);
    }

    public Mono<Void> removeRole(Snowflake roleId, @Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().removeGuildMemberRole(this.guildId, this.getId().asLong(), roleId.asLong(), reason);
    }

    public Mono<PermissionSet> getBasePermissions() {
        Mono<Boolean> getIsOwner = this.getGuild().map(guild -> guild.getOwnerId().equals(this.getId()));
        Mono<PermissionSet> getEveryonePerms = this.getGuild().flatMap(Guild::getEveryoneRole).map(Role::getPermissions);
        Mono<List<PermissionSet>> getRolePerms = this.getRoles().map(Role::getPermissions).collectList();
        return getIsOwner.filter(Predicate.isEqual(Boolean.TRUE)).flatMap(ignored -> Mono.just(PermissionSet.all())).switchIfEmpty(Mono.zip(getEveryonePerms, getRolePerms, PermissionUtil::computeBasePermissions));
    }

    public Mono<Boolean> isHigher(Member otherMember) {
        if (!this.getGuildId().equals(otherMember.getGuildId())) {
            return Mono.error(new IllegalArgumentException("The provided member is in a different guild."));
        }
        if (this.equals(otherMember)) {
            return Mono.just(false);
        }
        return this.getGuild().map(Guild::getOwnerId).flatMap(ownerId -> {
            if (ownerId.equals(this.getId())) {
                return Mono.just(true);
            }
            if (ownerId.equals(otherMember.getId())) {
                return Mono.just(false);
            }
            return this.hasHigherRoles(otherMember.getRoleIds());
        });
    }

    public Mono<Boolean> isHigher(Snowflake id) {
        return this.getClient().getMemberById(this.getGuildId(), id).flatMap(this::isHigher);
    }

    public Mono<Boolean> hasHigherRoles(Set<Snowflake> otherRoles) {
        return this.getGuild().flatMapMany(Guild::getRoles).transform(OrderUtil::orderRoles).collectList().map(guildRoles -> {
            Set<Snowflake> thisRoleIds = this.getRoleIds();
            int thisHighestRolePos = guildRoles.stream().filter(role -> thisRoleIds.contains(role.getId())).max(OrderUtil.ROLE_ORDER).map(guildRoles::indexOf).orElse(0);
            int otherHighestPos = guildRoles.stream().filter(role -> otherRoles.contains(role.getId())).max(OrderUtil.ROLE_ORDER).map(guildRoles::indexOf).orElse(0);
            return thisHighestRolePos > otherHighestPos;
        });
    }

    public Mono<Color> getColor() {
        Flux<Role> rolesWithColor = this.getRoles().filter(it -> !it.getColor().equals(Role.DEFAULT_COLOR));
        return MathFlux.max(rolesWithColor, OrderUtil.ROLE_ORDER).map(Role::getColor).defaultIfEmpty(Role.DEFAULT_COLOR);
    }

    public Mono<Void> edit(Consumer<? super GuildMemberEditSpec> spec) {
        return Mono.defer(() -> {
            GuildMemberEditSpec mutatedSpec = new GuildMemberEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getGuildService().modifyGuildMember(this.getGuildId().asLong(), this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        });
    }

    @Override
    public String toString() {
        return "Member{data=" + this.data + ", guildId=" + this.guildId + "} " + super.toString();
    }
}

