/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MessageChannel
extends Channel {
    public Optional<Snowflake> getLastMessageId();

    public Mono<Message> getLastMessage();

    public Mono<Message> getLastMessage(EntityRetrievalStrategy var1);

    public Optional<Instant> getLastPinTimestamp();

    public Mono<Message> createMessage(Consumer<? super MessageCreateSpec> var1);

    default public Mono<Message> createMessage(String message) {
        return this.createMessage((? super MessageCreateSpec spec) -> spec.setContent(message));
    }

    default public Mono<Message> createEmbed(Consumer<? super EmbedCreateSpec> spec) {
        return this.createMessage((? super MessageCreateSpec messageSpec) -> messageSpec.setEmbed(spec));
    }

    public Mono<Void> type();

    public Flux<Long> typeUntil(Publisher<?> var1);

    public Flux<Message> getMessagesBefore(Snowflake var1);

    public Flux<Message> getMessagesAfter(Snowflake var1);

    public Mono<Message> getMessageById(Snowflake var1);

    public Mono<Message> getMessageById(Snowflake var1, EntityRetrievalStrategy var2);

    public Flux<Message> getPinnedMessages();
}

