/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.Activity;
import discord4j.discordjson.json.ActivityUpdateRequest;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="ActivityUpdateRequest", generator="Immutables")
public final class ImmutableActivityUpdateRequest
implements ActivityUpdateRequest {
    private final String name;
    private final int type;
    private final String url;

    private ImmutableActivityUpdateRequest(String name, int type, Optional<String> url) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = type;
        this.url = url.orElse(null);
    }

    private ImmutableActivityUpdateRequest(ImmutableActivityUpdateRequest original, String name, int type, String url) {
        this.name = name;
        this.type = type;
        this.url = url;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="url")
    public Optional<String> url() {
        return Optional.ofNullable(this.url);
    }

    public final ImmutableActivityUpdateRequest withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, newValue, this.type, this.url);
    }

    public final ImmutableActivityUpdateRequest withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, value, this.url);
    }

    public final ImmutableActivityUpdateRequest withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, this.type, newValue);
    }

    public final ImmutableActivityUpdateRequest withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new ImmutableActivityUpdateRequest(this, this.name, this.type, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableActivityUpdateRequest && this.equalTo((ImmutableActivityUpdateRequest)another);
    }

    private boolean equalTo(ImmutableActivityUpdateRequest another) {
        return this.name.equals(another.name) && this.type == another.type && Objects.equals(this.url, another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.type;
        h += (h << 5) + Objects.hashCode(this.url);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ActivityUpdateRequest{");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.url != null) {
            builder.append(", ");
            builder.append("url=").append(this.url);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableActivityUpdateRequest fromJson(Json json) {
        Builder builder = ImmutableActivityUpdateRequest.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.url != null) {
            builder.url(json.url);
        }
        return builder.build();
    }

    public static ImmutableActivityUpdateRequest of(String name, int type, Optional<String> url) {
        return new ImmutableActivityUpdateRequest(name, type, url);
    }

    public static ImmutableActivityUpdateRequest copyOf(ActivityUpdateRequest instance) {
        if (instance instanceof ImmutableActivityUpdateRequest) {
            return (ImmutableActivityUpdateRequest)instance;
        }
        return ImmutableActivityUpdateRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ActivityUpdateRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private String name;
        private int type;
        private String url;

        private Builder() {
        }

        public final Builder from(ActivityUpdateRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Activity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Activity instance;
            Optional<String> urlOptional;
            if (object instanceof ActivityUpdateRequest && (urlOptional = (instance = (ActivityUpdateRequest)object).url()).isPresent()) {
                this.url(urlOptional);
            }
            if (object instanceof Activity) {
                instance = (Activity)object;
                this.name(instance.name());
                this.type(instance.type());
            }
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            return this;
        }

        @JsonProperty(value="url")
        public final Builder url(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public ImmutableActivityUpdateRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableActivityUpdateRequest(null, this.name, this.type, this.url);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ActivityUpdateRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ActivityUpdateRequest", generator="Immutables")
    static final class Json
    implements ActivityUpdateRequest {
        String name;
        int type;
        boolean typeIsSet;
        Optional<String> url = Optional.empty();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="url")
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> url() {
            throw new UnsupportedOperationException();
        }
    }
}

