/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event;

import discord4j.common.LogUtil;
import discord4j.core.event.DefaultEventDispatcher;
import discord4j.core.event.ReactiveEventAdapter;
import discord4j.core.event.ReplayingEventDispatcher;
import discord4j.core.event.domain.Event;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.scheduler.Scheduler;
import reactor.scheduler.forkjoin.ForkJoinPoolScheduler;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

public interface EventDispatcher {
    public static final Logger log = Loggers.getLogger(EventDispatcher.class);
    public static final Supplier<Scheduler> DEFAULT_EVENT_SCHEDULER = () -> ForkJoinPoolScheduler.create("d4j-events");

    public <E extends Event> Flux<E> on(Class<E> var1);

    default public <E extends Event, T> Flux<T> on(Class<E> eventClass, Function<E, Publisher<T>> mapper) {
        return this.on(eventClass).flatMap(event -> Flux.defer(() -> (Publisher)mapper.apply(event)).subscriberContext(ctx -> ctx.put("discord4j.shard", event.getShardInfo().getIndex())).onErrorResume(t -> {
            log.warn(LogUtil.format(Context.of("discord4j.shard", event.getShardInfo().getIndex()), "Error while handling {}"), eventClass.getSimpleName(), t);
            return Mono.empty();
        }));
    }

    default public Flux<Event> on(ReactiveEventAdapter adapter) {
        return this.on(Event.class).flatMap(event -> Flux.defer(() -> adapter.hookOnEvent((Event)event)).subscriberContext(ctx -> ctx.put("discord4j.shard", event.getShardInfo().getIndex())).onErrorResume(t -> {
            log.warn(LogUtil.format(Context.of("discord4j.shard", event.getShardInfo().getIndex()), "Error while handling {}"), event.getClass().getSimpleName(), t);
            return Mono.empty();
        }).then(Mono.just(event)));
    }

    public void publish(Event var1);

    public void shutdown();

    public static Builder builder() {
        return new DefaultEventDispatcher.Builder();
    }

    public static EventDispatcher buffering() {
        return EventDispatcher.builder().build();
    }

    public static EventDispatcher withEarliestEvents(int bufferSize) {
        return EventDispatcher.builder().eventProcessor(EmitterProcessor.create(bufferSize, false)).overflowStrategy(FluxSink.OverflowStrategy.DROP).build();
    }

    public static EventDispatcher withLatestEvents(int bufferSize) {
        return EventDispatcher.builder().eventProcessor(EmitterProcessor.create(bufferSize, false)).overflowStrategy(FluxSink.OverflowStrategy.LATEST).build();
    }

    public static EventDispatcher replaying() {
        return ReplayingEventDispatcher.create();
    }

    public static EventDispatcher replayingWithTimeout(Duration maxAge) {
        return new DefaultEventDispatcher(ReplayProcessor.createTimeout(maxAge), FluxSink.OverflowStrategy.IGNORE, DEFAULT_EVENT_SCHEDULER.get());
    }

    public static EventDispatcher replayingWithSize(int historySize) {
        return new DefaultEventDispatcher(ReplayProcessor.create(historySize), FluxSink.OverflowStrategy.IGNORE, DEFAULT_EVENT_SCHEDULER.get());
    }

    public static interface Builder {
        public DefaultEventDispatcher.Builder eventProcessor(FluxProcessor<Event, Event> var1);

        public DefaultEventDispatcher.Builder overflowStrategy(FluxSink.OverflowStrategy var1);

        public DefaultEventDispatcher.Builder eventScheduler(Scheduler var1);

        public EventDispatcher build();
    }
}

