/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.component;

import discord4j.core.object.component.ActionRow;
import discord4j.core.object.component.Button;
import discord4j.core.object.component.SelectMenu;
import discord4j.discordjson.json.ComponentData;

public class MessageComponent {
    private final ComponentData data;

    public static MessageComponent fromData(ComponentData data) {
        switch (Type.of(data.type())) {
            case ACTION_ROW: {
                return new ActionRow(data);
            }
            case BUTTON: {
                return new Button(data);
            }
            case SELECT_MENU: {
                return new SelectMenu(data);
            }
        }
        return new MessageComponent(data);
    }

    MessageComponent(ComponentData data) {
        this.data = data;
    }

    public ComponentData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public static enum Type {
        UNKNOWN(-1),
        ACTION_ROW(1),
        BUTTON(2),
        SELECT_MENU(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return ACTION_ROW;
                }
                case 2: {
                    return BUTTON;
                }
                case 3: {
                    return SELECT_MENU;
                }
            }
            return UNKNOWN;
        }
    }
}

