/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.AuditSpec;
import discord4j.discordjson.json.ChannelCreateRequest;
import discord4j.discordjson.json.ImmutableChannelCreateRequest;
import discord4j.discordjson.json.OverwriteData;
import discord4j.discordjson.possible.Possible;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class NewsChannelCreateSpec
implements AuditSpec<ChannelCreateRequest> {
    private final ImmutableChannelCreateRequest.Builder requestBuilder = ChannelCreateRequest.builder().type(Channel.Type.GUILD_NEWS.getValue());
    @Nullable
    private String reason;

    public NewsChannelCreateSpec setName(String name) {
        this.requestBuilder.name(name);
        return this;
    }

    public NewsChannelCreateSpec setTopic(String topic) {
        this.requestBuilder.topic(topic);
        return this;
    }

    public NewsChannelCreateSpec setPosition(int position) {
        this.requestBuilder.position(position);
        return this;
    }

    public NewsChannelCreateSpec setPermissionOverwrites(Set<? extends PermissionOverwrite> permissionOverwrites) {
        List<OverwriteData> raw = permissionOverwrites.stream().map(o -> OverwriteData.builder().id(o.getTargetId().asString()).type(o.getType().getValue()).allow(o.getAllowed().getRawValue()).deny(o.getDenied().getRawValue()).build()).collect(Collectors.toList());
        this.requestBuilder.permissionOverwrites(raw);
        return this;
    }

    public NewsChannelCreateSpec setParentId(@Nullable Snowflake parentId) {
        this.requestBuilder.parentId(parentId == null ? Possible.absent() : Possible.of(parentId.asString()));
        return this;
    }

    public NewsChannelCreateSpec setNsfw(boolean nsfw) {
        this.requestBuilder.nsfw(nsfw);
        return this;
    }

    public NewsChannelCreateSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public ChannelCreateRequest asRequest() {
        return this.requestBuilder.build();
    }
}

