/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.AuditLogData;
import discord4j.discordjson.json.AuditLogEntryData;
import discord4j.discordjson.json.IntegrationData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="AuditLogData", generator="Immutables")
public final class ImmutableAuditLogData
implements AuditLogData {
    private final List<WebhookData> webhooks;
    private final List<UserData> users;
    private final List<AuditLogEntryData> auditLogEntries;
    private final List<IntegrationData> integrations;

    private ImmutableAuditLogData(Iterable<? extends WebhookData> webhooks, Iterable<? extends UserData> users, Iterable<? extends AuditLogEntryData> auditLogEntries, Iterable<? extends IntegrationData> integrations) {
        this.webhooks = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(webhooks, true, false));
        this.users = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(users, true, false));
        this.auditLogEntries = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(auditLogEntries, true, false));
        this.integrations = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(integrations, true, false));
    }

    private ImmutableAuditLogData(ImmutableAuditLogData original, List<WebhookData> webhooks, List<UserData> users, List<AuditLogEntryData> auditLogEntries, List<IntegrationData> integrations) {
        this.webhooks = webhooks;
        this.users = users;
        this.auditLogEntries = auditLogEntries;
        this.integrations = integrations;
    }

    @Override
    @JsonProperty(value="webhooks")
    public List<WebhookData> webhooks() {
        return this.webhooks;
    }

    @Override
    @JsonProperty(value="users")
    public List<UserData> users() {
        return this.users;
    }

    @Override
    @JsonProperty(value="audit_log_entries")
    public List<AuditLogEntryData> auditLogEntries() {
        return this.auditLogEntries;
    }

    @Override
    @JsonProperty(value="integrations")
    public List<IntegrationData> integrations() {
        return this.integrations;
    }

    public final ImmutableAuditLogData withWebhooks(WebhookData ... elements) {
        List<WebhookData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuditLogData(this, newValue, this.users, this.auditLogEntries, this.integrations);
    }

    public final ImmutableAuditLogData withWebhooks(Iterable<? extends WebhookData> elements) {
        if (this.webhooks == elements) {
            return this;
        }
        List<WebhookData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(elements, true, false));
        return new ImmutableAuditLogData(this, newValue, this.users, this.auditLogEntries, this.integrations);
    }

    public final ImmutableAuditLogData withUsers(UserData ... elements) {
        List<UserData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuditLogData(this, this.webhooks, newValue, this.auditLogEntries, this.integrations);
    }

    public final ImmutableAuditLogData withUsers(Iterable<? extends UserData> elements) {
        if (this.users == elements) {
            return this;
        }
        List<UserData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(elements, true, false));
        return new ImmutableAuditLogData(this, this.webhooks, newValue, this.auditLogEntries, this.integrations);
    }

    public final ImmutableAuditLogData withAuditLogEntries(AuditLogEntryData ... elements) {
        List<AuditLogEntryData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuditLogData(this, this.webhooks, this.users, newValue, this.integrations);
    }

    public final ImmutableAuditLogData withAuditLogEntries(Iterable<? extends AuditLogEntryData> elements) {
        if (this.auditLogEntries == elements) {
            return this;
        }
        List<AuditLogEntryData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(elements, true, false));
        return new ImmutableAuditLogData(this, this.webhooks, this.users, newValue, this.integrations);
    }

    public final ImmutableAuditLogData withIntegrations(IntegrationData ... elements) {
        List<IntegrationData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAuditLogData(this, this.webhooks, this.users, this.auditLogEntries, newValue);
    }

    public final ImmutableAuditLogData withIntegrations(Iterable<? extends IntegrationData> elements) {
        if (this.integrations == elements) {
            return this;
        }
        List<IntegrationData> newValue = ImmutableAuditLogData.createUnmodifiableList(false, ImmutableAuditLogData.createSafeList(elements, true, false));
        return new ImmutableAuditLogData(this, this.webhooks, this.users, this.auditLogEntries, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuditLogData && this.equalTo((ImmutableAuditLogData)another);
    }

    private boolean equalTo(ImmutableAuditLogData another) {
        return this.webhooks.equals(another.webhooks) && this.users.equals(another.users) && this.auditLogEntries.equals(another.auditLogEntries) && this.integrations.equals(another.integrations);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.webhooks.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + this.auditLogEntries.hashCode();
        h += (h << 5) + this.integrations.hashCode();
        return h;
    }

    public String toString() {
        return "AuditLogData{webhooks=" + this.webhooks + ", users=" + this.users + ", auditLogEntries=" + this.auditLogEntries + ", integrations=" + this.integrations + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuditLogData fromJson(Json json) {
        Builder builder = ImmutableAuditLogData.builder();
        if (json.webhooks != null) {
            builder.addAllWebhooks(json.webhooks);
        }
        if (json.users != null) {
            builder.addAllUsers(json.users);
        }
        if (json.auditLogEntries != null) {
            builder.addAllAuditLogEntries(json.auditLogEntries);
        }
        if (json.integrations != null) {
            builder.addAllIntegrations(json.integrations);
        }
        return builder.build();
    }

    public static ImmutableAuditLogData of(List<WebhookData> webhooks, List<UserData> users, List<AuditLogEntryData> auditLogEntries, List<IntegrationData> integrations) {
        return ImmutableAuditLogData.of(webhooks, users, auditLogEntries, integrations);
    }

    public static ImmutableAuditLogData of(Iterable<? extends WebhookData> webhooks, Iterable<? extends UserData> users, Iterable<? extends AuditLogEntryData> auditLogEntries, Iterable<? extends IntegrationData> integrations) {
        return new ImmutableAuditLogData(webhooks, users, auditLogEntries, integrations);
    }

    public static ImmutableAuditLogData copyOf(AuditLogData instance) {
        if (instance instanceof ImmutableAuditLogData) {
            return (ImmutableAuditLogData)instance;
        }
        return ImmutableAuditLogData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AuditLogData", generator="Immutables")
    public static final class Builder {
        private List<WebhookData> webhooks = new ArrayList<WebhookData>();
        private List<UserData> users = new ArrayList<UserData>();
        private List<AuditLogEntryData> auditLogEntries = new ArrayList<AuditLogEntryData>();
        private List<IntegrationData> integrations = new ArrayList<IntegrationData>();

        private Builder() {
        }

        public final Builder from(AuditLogData instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllWebhooks(instance.webhooks());
            this.addAllUsers(instance.users());
            this.addAllAuditLogEntries(instance.auditLogEntries());
            this.addAllIntegrations(instance.integrations());
            return this;
        }

        public final Builder addWebhook(WebhookData element) {
            this.webhooks.add(Objects.requireNonNull(element, "webhooks element"));
            return this;
        }

        public final Builder addWebhooks(WebhookData ... elements) {
            for (WebhookData element : elements) {
                this.webhooks.add(Objects.requireNonNull(element, "webhooks element"));
            }
            return this;
        }

        @JsonProperty(value="webhooks")
        public final Builder webhooks(Iterable<? extends WebhookData> elements) {
            this.webhooks.clear();
            return this.addAllWebhooks(elements);
        }

        public final Builder addAllWebhooks(Iterable<? extends WebhookData> elements) {
            for (WebhookData webhookData : elements) {
                this.webhooks.add(Objects.requireNonNull(webhookData, "webhooks element"));
            }
            return this;
        }

        public final Builder addUser(UserData element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(UserData ... elements) {
            for (UserData element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        @JsonProperty(value="users")
        public final Builder users(Iterable<? extends UserData> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends UserData> elements) {
            for (UserData userData : elements) {
                this.users.add(Objects.requireNonNull(userData, "users element"));
            }
            return this;
        }

        public final Builder addAuditLogEntry(AuditLogEntryData element) {
            this.auditLogEntries.add(Objects.requireNonNull(element, "auditLogEntries element"));
            return this;
        }

        public final Builder addAuditLogEntries(AuditLogEntryData ... elements) {
            for (AuditLogEntryData element : elements) {
                this.auditLogEntries.add(Objects.requireNonNull(element, "auditLogEntries element"));
            }
            return this;
        }

        @JsonProperty(value="audit_log_entries")
        public final Builder auditLogEntries(Iterable<? extends AuditLogEntryData> elements) {
            this.auditLogEntries.clear();
            return this.addAllAuditLogEntries(elements);
        }

        public final Builder addAllAuditLogEntries(Iterable<? extends AuditLogEntryData> elements) {
            for (AuditLogEntryData auditLogEntryData : elements) {
                this.auditLogEntries.add(Objects.requireNonNull(auditLogEntryData, "auditLogEntries element"));
            }
            return this;
        }

        public final Builder addIntegration(IntegrationData element) {
            this.integrations.add(Objects.requireNonNull(element, "integrations element"));
            return this;
        }

        public final Builder addIntegrations(IntegrationData ... elements) {
            for (IntegrationData element : elements) {
                this.integrations.add(Objects.requireNonNull(element, "integrations element"));
            }
            return this;
        }

        @JsonProperty(value="integrations")
        public final Builder integrations(Iterable<? extends IntegrationData> elements) {
            this.integrations.clear();
            return this.addAllIntegrations(elements);
        }

        public final Builder addAllIntegrations(Iterable<? extends IntegrationData> elements) {
            for (IntegrationData integrationData : elements) {
                this.integrations.add(Objects.requireNonNull(integrationData, "integrations element"));
            }
            return this;
        }

        public ImmutableAuditLogData build() {
            return new ImmutableAuditLogData(null, ImmutableAuditLogData.createUnmodifiableList(true, this.webhooks), ImmutableAuditLogData.createUnmodifiableList(true, this.users), ImmutableAuditLogData.createUnmodifiableList(true, this.auditLogEntries), ImmutableAuditLogData.createUnmodifiableList(true, this.integrations));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuditLogData", generator="Immutables")
    static final class Json
    implements AuditLogData {
        List<WebhookData> webhooks = Collections.emptyList();
        List<UserData> users = Collections.emptyList();
        List<AuditLogEntryData> auditLogEntries = Collections.emptyList();
        List<IntegrationData> integrations = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="webhooks")
        public void setWebhooks(List<WebhookData> webhooks) {
            this.webhooks = webhooks;
        }

        @JsonProperty(value="users")
        public void setUsers(List<UserData> users) {
            this.users = users;
        }

        @JsonProperty(value="audit_log_entries")
        public void setAuditLogEntries(List<AuditLogEntryData> auditLogEntries) {
            this.auditLogEntries = auditLogEntries;
        }

        @JsonProperty(value="integrations")
        public void setIntegrations(List<IntegrationData> integrations) {
            this.integrations = integrations;
        }

        @Override
        public List<WebhookData> webhooks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<UserData> users() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AuditLogEntryData> auditLogEntries() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<IntegrationData> integrations() {
            throw new UnsupportedOperationException();
        }
    }
}

