/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import reactor.util.Logger;
import reactor.util.Loggers;

final class AccessLog {
    static final Logger log = Loggers.getLogger("reactor.netty.http.server.AccessLog");
    static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
    static final String COMMON_LOG_FORMAT = "{} - {} [{}] \"{} {} {}\" {} {} {} {} ms";
    static final String MISSING = "-";
    final String zonedDateTime;
    String address;
    CharSequence method;
    CharSequence uri;
    String protocol;
    String user = "-";
    CharSequence status;
    long contentLength;
    boolean chunked;
    long startTime = System.currentTimeMillis();
    int port;

    AccessLog() {
        this.zonedDateTime = ZonedDateTime.now().format(DATE_TIME_FORMATTER);
    }

    AccessLog address(String address) {
        this.address = Objects.requireNonNull(address, "address");
        return this;
    }

    AccessLog port(int port) {
        this.port = port;
        return this;
    }

    AccessLog method(CharSequence method) {
        this.method = Objects.requireNonNull(method, "method");
        return this;
    }

    AccessLog uri(CharSequence uri) {
        this.uri = Objects.requireNonNull(uri, "uri");
        return this;
    }

    AccessLog protocol(String protocol) {
        this.protocol = Objects.requireNonNull(protocol, "protocol");
        return this;
    }

    AccessLog status(CharSequence status) {
        this.status = Objects.requireNonNull(status, "status");
        return this;
    }

    AccessLog contentLength(long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    AccessLog increaseContentLength(long contentLength) {
        if (this.chunked) {
            this.contentLength += contentLength;
        }
        return this;
    }

    AccessLog chunked(boolean chunked) {
        this.chunked = chunked;
        return this;
    }

    long duration() {
        return System.currentTimeMillis() - this.startTime;
    }

    void log() {
        if (log.isInfoEnabled()) {
            log.info(COMMON_LOG_FORMAT, this.address, this.user, this.zonedDateTime, this.method, this.uri, this.protocol, this.status, this.contentLength > -1L ? Long.valueOf(this.contentLength) : MISSING, this.port, this.duration());
        }
    }
}

