/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2ServerUpgradeCodec;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2StreamFrameToHttpObjectCodec;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.util.AsciiString;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.netty.ConnectionObserver;
import reactor.netty.DisposableServer;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.HttpResources;
import reactor.netty.http.server.AccessLogHandler;
import reactor.netty.http.server.AccessLogHandlerH2;
import reactor.netty.http.server.ConnectionInfo;
import reactor.netty.http.server.Http2StreamBridgeHandler;
import reactor.netty.http.server.HttpServer;
import reactor.netty.http.server.HttpServerConfiguration;
import reactor.netty.http.server.HttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.server.HttpTrafficHandler;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.http.server.SimpleCompressionHandler;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;
import reactor.util.annotation.Nullable;

final class HttpServerBind
extends HttpServer
implements Function<ServerBootstrap, ServerBootstrap> {
    static final HttpServerBind INSTANCE = new HttpServerBind();
    static final Function<DisposableServer, DisposableServer> CLEANUP_GLOBAL_RESOURCE = DisposableBind::new;
    static final boolean ACCESS_LOG = Boolean.parseBoolean(System.getProperty("reactor.netty.http.server.accessLogEnabled", "false"));
    final TcpServer tcpServer;

    HttpServerBind() {
        this(DEFAULT_TCP_SERVER);
    }

    HttpServerBind(TcpServer tcpServer) {
        this.tcpServer = Objects.requireNonNull(tcpServer, "tcpServer");
    }

    @Override
    protected TcpServer tcpConfiguration() {
        return this.tcpServer;
    }

    @Override
    public Mono<? extends DisposableServer> bind(TcpServer delegate) {
        return delegate.bootstrap(this).bind().map(CLEANUP_GLOBAL_RESOURCE);
    }

    @Override
    public ServerBootstrap apply(ServerBootstrap b) {
        HttpServerConfiguration conf = HttpServerConfiguration.getAndClean(b);
        SslProvider ssl = SslProvider.findSslSupport(b);
        if (ssl != null && ssl.getDefaultConfigurationType() == null) {
            if ((conf.protocols & 2) == 2) {
                ssl = SslProvider.updateDefaultConfiguration(ssl, SslProvider.DefaultConfigurationType.H2);
                SslProvider.setBootstrap(b, ssl);
            } else {
                ssl = SslProvider.updateDefaultConfiguration(ssl, SslProvider.DefaultConfigurationType.TCP);
                SslProvider.setBootstrap(b, ssl);
            }
        }
        if (b.config().group() == null) {
            HttpResources loops = HttpResources.get();
            EventLoopGroup selector = loops.onServerSelect(LoopResources.DEFAULT_NATIVE);
            EventLoopGroup elg = loops.onServer(LoopResources.DEFAULT_NATIVE);
            b.group(selector, elg).channel(loops.onServerChannel(elg));
        }
        BootstrapHandlers.channelOperationFactory(b);
        if (ssl != null) {
            if ((conf.protocols & 1) == 1) {
                throw new IllegalArgumentException("Configured H2 Clear-Text protocol with TLS. Use the non clear-text h2 protocol via HttpServer#protocol or disable TLS via HttpServer#tcpConfiguration(tcp -> tcp.noSSL())");
            }
            if ((conf.protocols & 6) == 6) {
                return BootstrapHandlers.updateConfiguration(b, "reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new Http1OrH2Initializer(conf.decoder.maxInitialLineLength(), conf.decoder.maxHeaderSize(), conf.decoder.maxChunkSize(), conf.decoder.validateHeaders(), conf.decoder.initialBufferSize(), conf.minCompressionSize, HttpServerBind.compressPredicate(conf.compressPredicate, conf.minCompressionSize), conf.forwardedHeaderHandler, conf.cookieEncoder, conf.cookieDecoder, conf.uriTagValue, conf.idleTimeout));
            }
            if ((conf.protocols & 4) == 4) {
                return BootstrapHandlers.updateConfiguration(b, "reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new Http1Initializer(conf.decoder.maxInitialLineLength(), conf.decoder.maxHeaderSize(), conf.decoder.maxChunkSize(), conf.decoder.validateHeaders(), conf.decoder.initialBufferSize(), conf.minCompressionSize, HttpServerBind.compressPredicate(conf.compressPredicate, conf.minCompressionSize), conf.forwardedHeaderHandler, conf.cookieEncoder, conf.cookieDecoder, conf.uriTagValue, conf.idleTimeout));
            }
            if ((conf.protocols & 2) == 2) {
                return BootstrapHandlers.updateConfiguration(b, "reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new H2Initializer(conf.decoder.validateHeaders(), conf.minCompressionSize, HttpServerBind.compressPredicate(conf.compressPredicate, conf.minCompressionSize), conf.forwardedHeaderHandler, conf.cookieEncoder, conf.cookieDecoder));
            }
        } else {
            if ((conf.protocols & 2) == 2) {
                throw new IllegalArgumentException("Configured H2 protocol without TLS. Use a clear-text h2 protocol via HttpServer#protocol or configure TLS via HttpServer#secure");
            }
            if ((conf.protocols & 5) == 5) {
                return BootstrapHandlers.updateConfiguration(b, "reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new Http1OrH2CleartextInitializer(conf.decoder.maxInitialLineLength(), conf.decoder.maxHeaderSize(), conf.decoder.maxChunkSize(), conf.decoder.validateHeaders(), conf.decoder.initialBufferSize(), conf.minCompressionSize, HttpServerBind.compressPredicate(conf.compressPredicate, conf.minCompressionSize), conf.forwardedHeaderHandler, conf.cookieEncoder, conf.cookieDecoder, conf.uriTagValue, conf.decoder.h2cMaxContentLength, conf.idleTimeout));
            }
            if ((conf.protocols & 4) == 4) {
                return BootstrapHandlers.updateConfiguration(b, "reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new Http1Initializer(conf.decoder.maxInitialLineLength(), conf.decoder.maxHeaderSize(), conf.decoder.maxChunkSize(), conf.decoder.validateHeaders(), conf.decoder.initialBufferSize(), conf.minCompressionSize, HttpServerBind.compressPredicate(conf.compressPredicate, conf.minCompressionSize), conf.forwardedHeaderHandler, conf.cookieEncoder, conf.cookieDecoder, conf.uriTagValue, conf.idleTimeout));
            }
            if ((conf.protocols & 1) == 1) {
                return BootstrapHandlers.updateConfiguration(b, "reactor.left.httpInitializer", (BiConsumer<ConnectionObserver, ? super Channel>)new H2CleartextInitializer(conf.decoder.validateHeaders(), conf.minCompressionSize, HttpServerBind.compressPredicate(conf.compressPredicate, conf.minCompressionSize), conf.forwardedHeaderHandler, conf.cookieEncoder, conf.cookieDecoder));
            }
        }
        throw new IllegalArgumentException("An unknown HttpServer#protocol configuration has been provided: " + String.format("0x%x", conf.protocols));
    }

    @Nullable
    static BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate(@Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressionPredicate, int minResponseSize) {
        if (minResponseSize <= 0) {
            return compressionPredicate;
        }
        BiPredicate<HttpServerRequest, HttpServerResponse> lengthPredicate = (req, res) -> {
            String length = res.responseHeaders().get(HttpHeaderNames.CONTENT_LENGTH);
            if (length == null) {
                return true;
            }
            try {
                return Long.parseLong(length) >= (long)minResponseSize;
            }
            catch (NumberFormatException nfe) {
                return true;
            }
        };
        if (compressionPredicate != null) {
            lengthPredicate = lengthPredicate.and(compressionPredicate);
        }
        return lengthPredicate;
    }

    static void addStreamHandlers(Channel ch, ConnectionObserver listener, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder, int minCompressionSize) {
        boolean alwaysCompress;
        ChannelPipeline pipeline = ch.pipeline();
        if (ACCESS_LOG) {
            pipeline.addLast("reactor.left.accessLogHandler", (ChannelHandler)new AccessLogHandlerH2());
        }
        pipeline.addLast(new Http2StreamFrameToHttpObjectCodec(true)).addLast(new Http2StreamBridgeHandler(listener, forwardedHeaderHandler, encoder, decoder, compressPredicate));
        boolean bl = alwaysCompress = compressPredicate == null && minCompressionSize == 0;
        if (alwaysCompress) {
            pipeline.addLast("reactor.left.compressionHandler", (ChannelHandler)new SimpleCompressionHandler());
        }
        ChannelOperations.addReactiveBridge(ch, ChannelOperations.OnSetup.empty(), listener);
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(ch, "Initialized HTTP/2 pipeline {}"), pipeline);
        }
    }

    static final class Http2StreamInitializer
    extends ChannelInitializer<Channel> {
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ConnectionObserver listener;
        final ServerCookieEncoder cookieEncoder;
        final ServerCookieDecoder cookieDecoder;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final int minCompressionSize;

        Http2StreamInitializer(ConnectionObserver listener, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder, int minCompressionSize) {
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.listener = listener;
            this.cookieEncoder = encoder;
            this.cookieDecoder = decoder;
            this.compressPredicate = compressPredicate;
            this.minCompressionSize = minCompressionSize;
        }

        @Override
        protected void initChannel(Channel ch) {
            HttpServerBind.addStreamHandlers(ch, this.listener, this.compressPredicate, this.forwardedHeaderHandler, this.cookieEncoder, this.cookieDecoder, this.minCompressionSize);
        }
    }

    static final class H2Initializer
    implements BiConsumer<ConnectionObserver, Channel> {
        final boolean validate;
        final int minCompressionSize;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ServerCookieEncoder cookieEncoder;
        final ServerCookieDecoder cookieDecoder;

        H2Initializer(boolean validate, int minCompressionSize, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
            this.validate = validate;
            this.minCompressionSize = minCompressionSize;
            this.compressPredicate = compressPredicate;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.cookieEncoder = encoder;
            this.cookieDecoder = decoder;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            ChannelPipeline p = channel.pipeline();
            Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(this.validate).initialSettings(Http2Settings.defaultSettings());
            if (p.get("reactor.left.loggingHandler") != null) {
                http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2.secured"));
            }
            p.addLast("reactor.left.httpCodec", (ChannelHandler)http2FrameCodecBuilder.build()).addLast(new Http2MultiplexHandler(new Http2StreamInitializer(listener, this.compressPredicate, this.forwardedHeaderHandler, this.cookieEncoder, this.cookieDecoder, this.minCompressionSize)));
        }
    }

    static final class Http1OrH2Codec
    extends ApplicationProtocolNegotiationHandler {
        final ConnectionObserver listener;
        final Http1OrH2Initializer parent;

        Http1OrH2Codec(Http1OrH2Initializer parent, ConnectionObserver listener) {
            super("http/1.1");
            this.listener = listener;
            this.parent = parent;
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) {
            ChannelPipeline p = ctx.pipeline();
            if ("h2".equals(protocol)) {
                p.remove("reactor.right.reactiveBridge");
                Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(true).initialSettings(Http2Settings.defaultSettings());
                if (p.get("reactor.left.loggingHandler") != null) {
                    http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2.secure"));
                }
                p.addLast("reactor.left.httpCodec", (ChannelHandler)http2FrameCodecBuilder.build()).addLast(new Http2MultiplexHandler(new Http2StreamInitializer(this.listener, this.parent.compressPredicate, this.parent.forwardedHeaderHandler, this.parent.cookieEncoder, this.parent.cookieDecoder, this.parent.minCompressionSize)));
                return;
            }
            if ("http/1.1".equals(protocol)) {
                ChannelMetricsRecorder channelMetricsRecorder;
                ChannelHandler channelMetricsHandler;
                boolean alwaysCompress;
                p.addBefore("reactor.right.reactiveBridge", "reactor.left.httpCodec", new HttpServerCodec(this.parent.line, this.parent.header, this.parent.chunk, this.parent.validate, this.parent.buffer)).addBefore("reactor.right.reactiveBridge", "reactor.left.httpTrafficHandler", new HttpTrafficHandler(this.listener, this.parent.forwardedHeaderHandler, this.parent.compressPredicate, this.parent.cookieEncoder, this.parent.cookieDecoder, this.parent.idleTimeout));
                if (ACCESS_LOG) {
                    p.addAfter("reactor.left.httpCodec", "reactor.left.accessLogHandler", new AccessLogHandler());
                }
                boolean bl = alwaysCompress = this.parent.compressPredicate == null && this.parent.minCompressionSize == 0;
                if (alwaysCompress) {
                    p.addBefore("reactor.left.httpTrafficHandler", "reactor.left.compressionHandler", new SimpleCompressionHandler());
                }
                if ((channelMetricsHandler = p.get("reactor.left.channelMetricsHandler")) != null && (channelMetricsRecorder = ((ChannelMetricsHandler)channelMetricsHandler).recorder()) instanceof HttpServerMetricsRecorder) {
                    p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", new HttpServerMetricsHandler((HttpServerMetricsRecorder)channelMetricsRecorder, this.parent.uriTagValue));
                    if (channelMetricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                        p.remove(channelMetricsHandler);
                    }
                }
                return;
            }
            throw new IllegalStateException("unknown protocol: " + protocol);
        }
    }

    static final class Http1OrH2Initializer
    implements BiConsumer<ConnectionObserver, Channel> {
        final int line;
        final int header;
        final int chunk;
        final boolean validate;
        final int buffer;
        final int minCompressionSize;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ServerCookieEncoder cookieEncoder;
        final ServerCookieDecoder cookieDecoder;
        final Function<String, String> uriTagValue;
        final Duration idleTimeout;

        Http1OrH2Initializer(int line, int header, int chunk, boolean validate, int buffer, int minCompressionSize, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder, @Nullable Function<String, String> uriTagValue, @Nullable Duration idleTimeout) {
            this.line = line;
            this.header = header;
            this.chunk = chunk;
            this.validate = validate;
            this.buffer = buffer;
            this.minCompressionSize = minCompressionSize;
            this.compressPredicate = compressPredicate;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.cookieEncoder = encoder;
            this.cookieDecoder = decoder;
            this.uriTagValue = uriTagValue;
            this.idleTimeout = idleTimeout;
        }

        @Override
        public void accept(ConnectionObserver observer, Channel channel) {
            channel.pipeline().addLast(new Http1OrH2Codec(this, observer));
        }
    }

    static final class H2CleartextInitializer
    implements BiConsumer<ConnectionObserver, Channel> {
        final boolean validate;
        final int minCompressionSize;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ServerCookieEncoder cookieEncoder;
        final ServerCookieDecoder cookieDecoder;

        H2CleartextInitializer(boolean validate, int minCompressionSize, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder) {
            this.validate = validate;
            this.minCompressionSize = minCompressionSize;
            this.compressPredicate = compressPredicate;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.cookieEncoder = encoder;
            this.cookieDecoder = decoder;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            ChannelPipeline p = channel.pipeline();
            Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(this.validate).initialSettings(Http2Settings.defaultSettings());
            if (p.get("reactor.left.loggingHandler") != null) {
                http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2.cleartext"));
            }
            p.addLast("reactor.left.httpCodec", (ChannelHandler)http2FrameCodecBuilder.build()).addLast(new Http2MultiplexHandler(new Http2StreamInitializer(listener, this.compressPredicate, this.forwardedHeaderHandler, this.cookieEncoder, this.cookieDecoder, this.minCompressionSize)));
            channel.read();
        }
    }

    @ChannelHandler.Sharable
    static final class Http1OrH2CleartextCodec
    extends ChannelInitializer<Channel>
    implements HttpServerUpgradeHandler.UpgradeCodecFactory {
        final Http1OrH2CleartextInitializer parent;
        final ConnectionObserver listener;
        final Http2FrameCodec http2FrameCodec;

        Http1OrH2CleartextCodec(Http1OrH2CleartextInitializer parent, ConnectionObserver listener, boolean debug) {
            this.parent = parent;
            this.listener = listener;
            Http2FrameCodecBuilder http2FrameCodecBuilder = Http2FrameCodecBuilder.forServer().validateHeaders(parent.validate).initialSettings(Http2Settings.defaultSettings());
            if (debug) {
                http2FrameCodecBuilder.frameLogger(new Http2FrameLogger(LogLevel.DEBUG, "reactor.netty.http.server.h2.cleartext"));
            }
            this.http2FrameCodec = http2FrameCodecBuilder.build();
        }

        @Override
        protected void initChannel(Channel ch) {
            HttpServerBind.addStreamHandlers(ch, this.listener, this.parent.compressPredicate, this.parent.forwardedHeaderHandler, this.parent.cookieEncoder, this.parent.cookieDecoder, this.parent.minCompressionSize);
        }

        @Override
        @Nullable
        public HttpServerUpgradeHandler.UpgradeCodec newUpgradeCodec(CharSequence protocol) {
            if (AsciiString.contentEquals(Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, protocol)) {
                return new Http2ServerUpgradeCodec(this.http2FrameCodec, new Http2MultiplexHandler(this));
            }
            return null;
        }
    }

    static final class Http1OrH2CleartextInitializer
    implements BiConsumer<ConnectionObserver, Channel> {
        final int line;
        final int header;
        final int chunk;
        final boolean validate;
        final int buffer;
        final int minCompressionSize;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ServerCookieEncoder cookieEncoder;
        final ServerCookieDecoder cookieDecoder;
        final Function<String, String> uriTagValue;
        final int h2cMaxContentLength;
        final Duration idleTimeout;

        Http1OrH2CleartextInitializer(int line, int header, int chunk, boolean validate, int buffer, int minCompressionSize, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder, @Nullable Function<String, String> uriTagValue, int h2cMaxContentLength, @Nullable Duration idleTimeout) {
            this.line = line;
            this.header = header;
            this.chunk = chunk;
            this.validate = validate;
            this.buffer = buffer;
            this.minCompressionSize = minCompressionSize;
            this.compressPredicate = compressPredicate;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.cookieEncoder = encoder;
            this.cookieDecoder = decoder;
            this.uriTagValue = uriTagValue;
            this.h2cMaxContentLength = h2cMaxContentLength;
            this.idleTimeout = idleTimeout;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            ChannelMetricsRecorder channelMetricsRecorder;
            boolean alwaysCompress;
            ChannelPipeline p = channel.pipeline();
            HttpServerCodec httpServerCodec = new HttpServerCodec(this.line, this.header, this.chunk, this.validate, this.buffer);
            final Http1OrH2CleartextCodec upgrader = new Http1OrH2CleartextCodec(this, listener, p.get("reactor.left.loggingHandler") != null);
            ChannelHandlerAdapter http2ServerHandler = new ChannelHandlerAdapter(){

                @Override
                public void handlerAdded(ChannelHandlerContext ctx) {
                    ChannelPipeline pipeline = ctx.pipeline();
                    pipeline.addAfter(ctx.name(), "reactor.left.httpCodec", upgrader.http2FrameCodec).addAfter("reactor.left.httpCodec", null, new Http2MultiplexHandler(upgrader)).remove(this);
                    if (pipeline.get("reactor.left.accessLogHandler") != null) {
                        pipeline.remove("reactor.left.accessLogHandler");
                    }
                    if (pipeline.get("reactor.left.compressionHandler") != null) {
                        pipeline.remove("reactor.left.compressionHandler");
                    }
                    pipeline.remove("reactor.left.httpTrafficHandler");
                    pipeline.remove("reactor.right.reactiveBridge");
                }
            };
            CleartextHttp2ServerUpgradeHandler h2cUpgradeHandler = new CleartextHttp2ServerUpgradeHandler(httpServerCodec, new HttpServerUpgradeHandler(httpServerCodec, upgrader, this.h2cMaxContentLength), http2ServerHandler);
            p.addLast(h2cUpgradeHandler);
            if (ACCESS_LOG) {
                p.addLast("reactor.left.accessLogHandler", (ChannelHandler)new AccessLogHandler());
            }
            boolean bl = alwaysCompress = this.compressPredicate == null && this.minCompressionSize == 0;
            if (alwaysCompress) {
                p.addLast("reactor.left.compressionHandler", (ChannelHandler)new SimpleCompressionHandler());
            }
            p.addLast("reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(listener, this.forwardedHeaderHandler, this.compressPredicate, this.cookieEncoder, this.cookieDecoder, this.idleTimeout));
            ChannelHandler channelMetricsHandler = p.get("reactor.left.channelMetricsHandler");
            if (channelMetricsHandler != null && (channelMetricsRecorder = ((ChannelMetricsHandler)channelMetricsHandler).recorder()) instanceof HttpServerMetricsRecorder) {
                p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", new HttpServerMetricsHandler((HttpServerMetricsRecorder)channelMetricsRecorder, this.uriTagValue));
                if (channelMetricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                    p.remove(channelMetricsHandler);
                }
            }
        }
    }

    static final class Http1Initializer
    implements BiConsumer<ConnectionObserver, Channel> {
        final int line;
        final int header;
        final int chunk;
        final boolean validate;
        final int buffer;
        final int minCompressionSize;
        final BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate;
        final BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler;
        final ServerCookieEncoder cookieEncoder;
        final ServerCookieDecoder cookieDecoder;
        final Function<String, String> uriTagValue;
        final Duration idleTimeout;

        Http1Initializer(int line, int header, int chunk, boolean validate, int buffer, int minCompressionSize, @Nullable BiPredicate<HttpServerRequest, HttpServerResponse> compressPredicate, @Nullable BiFunction<ConnectionInfo, HttpRequest, ConnectionInfo> forwardedHeaderHandler, ServerCookieEncoder encoder, ServerCookieDecoder decoder, @Nullable Function<String, String> uriTagValue, @Nullable Duration idleTimeout) {
            this.line = line;
            this.header = header;
            this.chunk = chunk;
            this.validate = validate;
            this.buffer = buffer;
            this.minCompressionSize = minCompressionSize;
            this.compressPredicate = compressPredicate;
            this.forwardedHeaderHandler = forwardedHeaderHandler;
            this.cookieEncoder = encoder;
            this.cookieDecoder = decoder;
            this.uriTagValue = uriTagValue;
            this.idleTimeout = idleTimeout;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            ChannelMetricsRecorder channelMetricsRecorder;
            boolean alwaysCompress;
            ChannelPipeline p = channel.pipeline();
            p.addLast("reactor.left.httpCodec", (ChannelHandler)new HttpServerCodec(this.line, this.header, this.chunk, this.validate, this.buffer));
            if (ACCESS_LOG) {
                p.addLast("reactor.left.accessLogHandler", (ChannelHandler)new AccessLogHandler());
            }
            boolean bl = alwaysCompress = this.compressPredicate == null && this.minCompressionSize == 0;
            if (alwaysCompress) {
                p.addLast("reactor.left.compressionHandler", (ChannelHandler)new SimpleCompressionHandler());
            }
            p.addLast("reactor.left.httpTrafficHandler", (ChannelHandler)new HttpTrafficHandler(listener, this.forwardedHeaderHandler, this.compressPredicate, this.cookieEncoder, this.cookieDecoder, this.idleTimeout));
            ChannelHandler channelMetricsHandler = p.get("reactor.left.channelMetricsHandler");
            if (channelMetricsHandler != null && (channelMetricsRecorder = ((ChannelMetricsHandler)channelMetricsHandler).recorder()) instanceof HttpServerMetricsRecorder) {
                p.addAfter("reactor.left.httpTrafficHandler", "reactor.left.httpMetricsHandler", new HttpServerMetricsHandler((HttpServerMetricsRecorder)channelMetricsRecorder, this.uriTagValue));
                if (channelMetricsRecorder instanceof MicrometerHttpServerMetricsRecorder) {
                    p.remove(channelMetricsHandler);
                }
            }
        }
    }

    static final class DisposableBind
    implements DisposableServer {
        final DisposableServer server;

        DisposableBind(DisposableServer server) {
            this.server = server;
        }

        @Override
        public void dispose() {
            this.server.dispose();
            HttpResources.get().disposeWhen(this.server.address());
        }

        @Override
        public void disposeNow(Duration timeout) {
            if (this.isDisposed()) {
                return;
            }
            this.server.disposeNow(timeout);
        }

        @Override
        public Channel channel() {
            return this.server.channel();
        }
    }
}

