/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.annotations.Experimental;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.AllowedMentionsData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Experimental
public class InteractionApplicationCommandCallbackSpec
implements Spec<InteractionApplicationCommandCallbackData> {
    @Nullable
    private String content;
    private boolean tts;
    private List<EmbedData> embeds;
    private AllowedMentionsData allowedMentionsData;
    private int flags;
    private List<LayoutComponent> components;

    public InteractionApplicationCommandCallbackSpec setContent(String content) {
        this.content = content;
        return this;
    }

    public InteractionApplicationCommandCallbackSpec setTts(boolean tts) {
        this.tts = tts;
        return this;
    }

    public InteractionApplicationCommandCallbackSpec setEphemeral(boolean ephemeral) {
        this.flags = ephemeral ? Message.Flag.EPHEMERAL.getFlag() : 0;
        return this;
    }

    public InteractionApplicationCommandCallbackSpec addEmbed(Consumer<? super EmbedCreateSpec> spec) {
        if (this.embeds == null) {
            this.embeds = new ArrayList<EmbedData>(1);
        }
        EmbedCreateSpec mutatedSpec = new EmbedCreateSpec();
        spec.accept(mutatedSpec);
        this.embeds.add(mutatedSpec.asRequest());
        return this;
    }

    public InteractionApplicationCommandCallbackSpec setAllowedMentions(@Nullable AllowedMentions allowedMentions) {
        this.allowedMentionsData = allowedMentions != null ? allowedMentions.toData() : null;
        return this;
    }

    public InteractionApplicationCommandCallbackSpec setComponents(LayoutComponent ... components) {
        return this.setComponents(Arrays.asList(components));
    }

    public InteractionApplicationCommandCallbackSpec setComponents(List<LayoutComponent> components) {
        this.components = components;
        return this;
    }

    @Override
    public InteractionApplicationCommandCallbackData asRequest() {
        return InteractionApplicationCommandCallbackData.builder().content(this.content == null ? Possible.absent() : Possible.of(this.content)).tts(this.tts).flags(this.flags == 0 ? Possible.absent() : Possible.of(this.flags)).embeds(this.embeds == null ? Possible.absent() : Possible.of(this.embeds)).allowedMentions(this.allowedMentionsData == null ? Possible.absent() : Possible.of(this.allowedMentionsData)).components(this.components == null ? Possible.absent() : Possible.of(this.components.stream().map(MessageComponent::getData).collect(Collectors.toList()))).build();
    }
}

