/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.state;

import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PresenceData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.intent.IntentSet;
import discord4j.store.api.Store;
import discord4j.store.api.noop.NoOpLongObjStore;
import discord4j.store.api.noop.NoOpStore;
import discord4j.store.api.primitive.LongObjStore;
import discord4j.store.api.service.StoreService;
import discord4j.store.api.util.LongLongTuple2;
import discord4j.store.api.util.StoreContext;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class StateHolder {
    private static final Logger log = Loggers.getLogger(StateHolder.class);
    private final StoreService storeService;
    private final LongObjStore<ChannelData> channelStore;
    private final LongObjStore<GuildData> guildStore;
    private final LongObjStore<EmojiData> guildEmojiStore;
    private final Store<LongLongTuple2, MemberData> memberStore;
    private final LongObjStore<MessageData> messageStore;
    private final Store<LongLongTuple2, PresenceData> presenceStore;
    private final LongObjStore<RoleData> roleStore;
    private final LongObjStore<UserData> userStore;
    private final Store<LongLongTuple2, VoiceStateData> voiceStateStore;

    public StateHolder(StoreService service, StoreContext context, Possible<IntentSet> intentSet) {
        this.storeService = service;
        service.init(context);
        Optional<IntentSet> intents = intentSet.toOptional();
        this.channelStore = service.provideLongObjStore(ChannelData.class);
        log.debug("Channel storage     : {}", this.channelStore);
        this.guildStore = service.provideLongObjStore(GuildData.class);
        log.debug("Guild storage       : {}", this.guildStore);
        if (intents.map(set -> !set.contains((Object)Intent.GUILD_EMOJIS)).orElse(false).booleanValue()) {
            this.guildEmojiStore = new NoOpLongObjStore<EmojiData>();
            log.debug("Guild emoji storage : Disabled due to missing GUILD_EMOJIS intent");
        } else {
            this.guildEmojiStore = service.provideLongObjStore(EmojiData.class);
            log.debug("Guild emoji storage : {}", this.guildEmojiStore);
        }
        this.memberStore = service.provideGenericStore(LongLongTuple2.class, MemberData.class);
        log.debug("Member storage      : {}", this.memberStore);
        this.messageStore = service.provideLongObjStore(MessageData.class);
        log.debug("Message storage     : {}", this.messageStore);
        if (intents.map(set -> !set.contains((Object)Intent.GUILD_PRESENCES)).orElse(false).booleanValue()) {
            this.presenceStore = new NoOpStore<LongLongTuple2, PresenceData>();
            log.debug("Presence storage    : Disabled due to missing GUILD_PRESENCES intent");
        } else {
            this.presenceStore = service.provideGenericStore(LongLongTuple2.class, PresenceData.class);
            log.debug("Presence storage    : {}", this.presenceStore);
        }
        this.roleStore = service.provideLongObjStore(RoleData.class);
        log.debug("Role storage        : {}", this.roleStore);
        this.userStore = service.provideLongObjStore(UserData.class);
        log.debug("User storage        : {}", this.userStore);
        if (intents.map(set -> !set.contains((Object)Intent.GUILD_VOICE_STATES)).orElse(false).booleanValue()) {
            this.voiceStateStore = new NoOpStore<LongLongTuple2, VoiceStateData>();
            log.debug("Voice state storage : Disabled due to missing GUILD_VOICE_STATES intent");
        } else {
            this.voiceStateStore = service.provideGenericStore(LongLongTuple2.class, VoiceStateData.class);
            log.debug("Voice state storage : {}", this.voiceStateStore);
        }
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public LongObjStore<ChannelData> getChannelStore() {
        return this.channelStore;
    }

    public LongObjStore<GuildData> getGuildStore() {
        return this.guildStore;
    }

    public LongObjStore<EmojiData> getGuildEmojiStore() {
        return this.guildEmojiStore;
    }

    public Store<LongLongTuple2, MemberData> getMemberStore() {
        return this.memberStore;
    }

    public LongObjStore<MessageData> getMessageStore() {
        return this.messageStore;
    }

    public Store<LongLongTuple2, PresenceData> getPresenceStore() {
        return this.presenceStore;
    }

    public LongObjStore<RoleData> getRoleStore() {
        return this.roleStore;
    }

    public LongObjStore<UserData> getUserStore() {
        return this.userStore;
    }

    public Store<LongLongTuple2, VoiceStateData> getVoiceStateStore() {
        return this.voiceStateStore;
    }

    public Mono<Void> invalidateStores() {
        return this.channelStore.invalidate().and(this.guildStore.invalidate()).and(this.guildEmojiStore.invalidate()).and(this.memberStore.invalidate()).and(this.messageStore.invalidate()).and(this.presenceStore.invalidate()).and(this.roleStore.invalidate()).and(this.userStore.invalidate()).and(this.voiceStateStore.invalidate());
    }
}

