/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.entity;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.WebhookModifyRequest;
import discord4j.rest.RestClient;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestWebhook {
    private final RestClient restClient;
    private final long id;

    private RestWebhook(RestClient restClient, long id) {
        this.restClient = restClient;
        this.id = id;
    }

    public static RestWebhook create(RestClient restClient, Snowflake id) {
        return new RestWebhook(restClient, id.asLong());
    }

    static RestWebhook create(RestClient restClient, long id) {
        return new RestWebhook(restClient, id);
    }

    public Snowflake getId() {
        return Snowflake.of(this.id);
    }

    public Mono<WebhookData> getData() {
        return this.restClient.getWebhookService().getWebhook(this.id);
    }

    public Mono<WebhookData> modify(WebhookModifyRequest request, @Nullable String reason) {
        return this.restClient.getWebhookService().modifyWebhook(this.id, request, reason);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.restClient.getWebhookService().deleteWebhook(this.id, reason);
    }
}

