/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.math.MathSubscriber;
import reactor.math.MonoFromFluxOperator;

final class MonoSumInt<T>
extends MonoFromFluxOperator<T, Integer>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumInt(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(Flux.from(source));
        this.mapping = mapping;
    }

    @Override
    public void subscribe(CoreSubscriber<? super Integer> s) {
        this.source.subscribe(new SumIntSubscriber<T>(s, this.mapping));
    }

    static final class SumIntSubscriber<T>
    extends MathSubscriber<T, Integer> {
        final Function<? super T, ? extends Number> mapping;
        int sum;
        boolean hasValue;

        SumIntSubscriber(CoreSubscriber<? super Integer> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            int intValue = this.mapping.apply(newValue).intValue();
            if (this.hasValue) {
                boolean sumPositive = this.sum >= 0;
                this.sum += intValue;
                if (sumPositive && intValue >= 0 && this.sum < 0) {
                    this.sum = Integer.MAX_VALUE;
                } else if (!sumPositive && intValue < 0 && this.sum > 0) {
                    this.sum = Integer.MIN_VALUE;
                }
            } else {
                this.sum = intValue;
                this.hasValue = true;
            }
        }

        @Override
        protected Integer result() {
            return this.hasValue ? Integer.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0;
            this.hasValue = false;
        }
    }
}

