/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.term;

import java.io.PrintStream;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum ANSI {
    BR("\n"),
    BELL("\u0007"),
    BOLD("\u001b[1m"),
    BOLDOFF("\u001b[22m"),
    BLINK("\u001b[5m"),
    BLINKOFF("\u001b[25m"),
    BLACK("\u001b[30m"),
    BLACKOFF("\u001b[39m"),
    RED("\u001b[31m"),
    REDOFF("\u001b[39m"),
    GREEN("\u001b[32m"),
    GREENOFF("\u001b[39m"),
    YELLOW("\u001b[33m"),
    YELLOWOFF("\u001b[39m"),
    BLUE("\u001b[34m"),
    BLUEOFF("\u001b[39m"),
    MAGENTA("\u001b[35m"),
    MAGENTAOFF("\u001b[39m"),
    CYAN("\u001b[36m"),
    CYANOFF("\u001b[39m"),
    WHITE("\u001b[37m"),
    WHITEOFF("\u001b[39m"),
    SYSTEM("\u001b[39m"),
    RESET("\u001b[0m");

    public static Scanner keyboard;
    public static PrintStream console;
    private static Pattern pattern;
    private final String code;

    private ANSI(String code) {
        this.code = code;
    }

    public String toString() {
        return this.code;
    }

    public String str() {
        return this.code;
    }

    public static String parse(String string) {
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String token = matcher.group(1);
            if (token.charAt(0) == '/') {
                token = token.substring(1).concat("OFF");
            }
            if (!ANSI.contains(token)) continue;
            string = string.replace("[".concat(matcher.group(1).concat("]")), ANSI.valueOf(token).str());
        }
        return string;
    }

    private static boolean contains(String name) {
        String search = name.toUpperCase();
        return Stream.of(ANSI.values()).anyMatch(value -> value.name().equals(search));
    }

    public static void printAnsi(String string) {
        console.print(ANSI.parse(string));
    }

    public static void printErr(String string) {
        console.printf("\u001b[1;91m%s\u001b[0m\n>\u001b[34m", ANSI.parse(string));
    }

    public static void println(String string) {
        console.printf("\u001b[0m%s\n>\u001b[34m", ANSI.parse(string));
    }

    public static void print(String string) {
        console.printf("\u001b[0m%s", ANSI.parse(string));
    }

    public static void printReady() {
        console.printf("\u001b[0m\n%s", ">\u001b[34m");
    }

    static {
        pattern = Pattern.compile("\\[(.*?)\\]");
        keyboard = new Scanner(System.in);
        console = System.out;
    }
}

