/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.mysql;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.mysql.DatabaseConnection;
import com.gmail.berndivader.streamserver.term.ANSI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class AddScheduled
implements Runnable {
    String sql_insert = "INSERT INTO `scheduled` (`title`, `filename`) VALUES(?, ?);";
    String sql_testfor = "SELECT `filename` from `scheduled` where `filename` = ?";
    String title;
    String filename;

    public AddScheduled(String filename) {
        this.title = filename.substring(0, filename.length() - 4);
        this.filename = filename;
        Helper.executor.submit(this);
    }

    @Override
    public void run() {
        boolean exists;
        block21: {
            exists = false;
            try (Connection connection = DatabaseConnection.getNewConnection();){
                try (PreparedStatement testfor = connection.prepareStatement(this.sql_testfor, 1004, 1007);){
                    testfor.setString(1, this.filename);
                    ResultSet result = testfor.executeQuery();
                    result.last();
                    exists = result.getRow() > 0;
                }
                if (exists) break block21;
                try (PreparedStatement insert = connection.prepareStatement(this.sql_insert, 1005, 1008);){
                    insert.setString(1, this.title);
                    insert.setString(2, this.filename);
                    insert.execute();
                }
            }
            catch (SQLException e) {
                ANSI.printErr("Failed to add a file to the scheduled playlist", e);
                return;
            }
        }
        ANSI.println(exists ? "\n[MYSQL TRACK ADDED FOR SCHEDULE]" : "\n[MYSQL TRACK ALREADY ON SCHEDULE]");
    }
}

