/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest;

import discord4j.common.JacksonResources;
import discord4j.common.ReactorResources;
import discord4j.common.util.Snowflake;
import discord4j.common.util.TokenUtil;
import discord4j.rest.request.Router;
import discord4j.rest.util.AllowedMentions;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class RestResources {
    private final String token;
    private final ReactorResources reactorResources;
    private final JacksonResources jacksonResources;
    private final Router router;
    private final long selfId;
    @Nullable
    private final AllowedMentions allowedMentions;

    public RestResources(String token, ReactorResources reactorResources, JacksonResources jacksonResources, Router router, @Nullable AllowedMentions allowedMentions) {
        this.token = token;
        this.reactorResources = reactorResources;
        this.jacksonResources = jacksonResources;
        this.router = router;
        this.selfId = TokenUtil.getSelfId(token);
        this.allowedMentions = allowedMentions;
    }

    public String getToken() {
        return this.token;
    }

    public ReactorResources getReactorResources() {
        return this.reactorResources;
    }

    public JacksonResources getJacksonResources() {
        return this.jacksonResources;
    }

    public Router getRouter() {
        return this.router;
    }

    public Snowflake getSelfId() {
        return Snowflake.of(this.selfId);
    }

    public Optional<AllowedMentions> getAllowedMentions() {
        return Optional.ofNullable(this.allowedMentions);
    }
}

