/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.berndivader.streamserver.discord.command.commands;

import com.gmail.berndivader.streamserver.Helper;
import com.gmail.berndivader.streamserver.annotation.DiscordCommand;
import com.gmail.berndivader.streamserver.config.Config;
import com.gmail.berndivader.streamserver.discord.command.Command;
import com.gmail.berndivader.streamserver.ffmpeg.InfoPacket;
import com.gmail.berndivader.streamserver.term.ANSI;
import discord4j.core.event.domain.interaction.ButtonInteractEvent;
import discord4j.core.object.component.ActionRow;
import discord4j.core.object.component.Button;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.rest.util.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

@DiscordCommand(name="dl", usage="Download media. [--no-default] [--dir] [--yes-playlist] --url <valid_url>")
public class DownloadMedia
extends Command<Void> {
    @Override
    public Mono<Void> execute(String string, MessageChannel channel) {
        Helper.EXECUTOR.submit(new ProcessCallback(string, channel));
        return Mono.empty();
    }

    private class ProcessCallback
    implements Runnable {
        private String line;
        private final MessageChannel channel;
        private final String uuid;
        private Status status = Status.NONE;

        public ProcessCallback(String line, MessageChannel channel) {
            this.line = line;
            this.channel = channel;
            this.uuid = UUID.randomUUID().toString();
        }

        @Override
        public void run() {
            File directory = new File(Config.DL_MUSIC_PATH);
            if (!directory.exists()) {
                directory.mkdir();
            }
            if (!directory.exists() || directory.isFile()) {
                this.channel.createMessage(msg -> msg.addEmbed(embed -> embed.setTitle("ERROR DLP!").setColor(Color.RED).setDescription("There was an issue with the download directory configured in Config.DL_MUSIC_PATH. It is either a file or the directory couldnt be created by the bot."))).subscribe();
                return;
            }
            this.channel.createMessage(msg -> msg.addEmbed(embed -> {
                embed.setTitle("Prepare download media file.");
                embed.setColor(Color.GREEN);
            })).doOnSuccess(message -> {
                Map.Entry<ProcessBuilder, Optional<InfoPacket>> entry = Helper.prepareDownloadBuilder(directory, this.line);
                ProcessBuilder builder = entry.getKey();
                Optional<InfoPacket> infoPacket = entry.getValue();
                try {
                    message.edit(msg -> msg.setComponents(ActionRow.of(Button.danger(this.uuid, "Cancel"))).setContent("Starting download...").addEmbed(embed -> infoPacket.ifPresent(info -> embed.setTitle(info.title).setAuthor(info.uploader, info.channel_url, info.thumbnail).setImage(info.thumbnail).setColor(Color.BLUE).setUrl(info.webpage_url).setFooter(info.format, info.thumbnail)))).subscribe();
                    Disposable listener = message.getClient().on(ButtonInteractEvent.class, event -> {
                        if (event.getCustomId().equals(this.uuid)) {
                            this.status = Status.ABORTED;
                            return event.edit(msg -> msg.setContent("").addEmbed(embed -> embed.setTitle("Aborted").setDescription("Media download aborted by user.").setColor(Color.RED)).setComponents(new ArrayList<LayoutComponent>()));
                        }
                        return Mono.empty();
                    }).subscribe();
                    Process process = builder.start();
                    BufferedReader input = process.inputReader();
                    long time = System.currentTimeMillis();
                    this.status = Status.RUNNING;
                    while (this.status == Status.RUNNING) {
                        if (!process.isAlive()) {
                            this.status = Status.FINISHED;
                            break;
                        }
                        if (input.ready()) {
                            time = System.currentTimeMillis();
                            String line2 = input.readLine();
                            if (line2.contains("[EmbedThumbnail]")) {
                                infoPacket.ifPresent(info -> {
                                    String[] temp = line2.split("\"");
                                    if (temp.length > 0) {
                                        info.local_filename = temp[1];
                                    }
                                });
                            }
                            message.edit(msg -> msg.setContent(line2));
                            continue;
                        }
                        if (System.currentTimeMillis() - time <= Config.DL_TIMEOUT_SECONDS * 1000L) continue;
                        this.status = Status.TIMEOUT;
                    }
                    BufferedReader error = process.errorReader();
                    StringBuilder errorBuilder = new StringBuilder();
                    error.lines().filter(line -> !line.startsWith("WARNING")).forEach(line -> errorBuilder.append((String)line));
                    if (errorBuilder.length() > 0) {
                        this.status = Status.ERROR;
                    }
                    message.edit(msg -> {
                        msg.setComponents(new ArrayList<LayoutComponent>());
                        msg.addEmbed(embed -> {
                            switch (this.status) {
                                case TIMEOUT: {
                                    msg.setContent("");
                                    embed.setTitle("TIMEOUT").setDescription("Download will be terminated, because it appears, that the process is stalled since " + Config.DL_TIMEOUT_SECONDS / 60L + " minutes.").setColor(Color.RED);
                                    break;
                                }
                                case FINISHED: {
                                    msg.setContent("FINISHED");
                                    infoPacket.ifPresent(info -> embed.setTitle(info.title).setAuthor(info.uploader, info.channel_url, info.thumbnail).setImage(info.thumbnail).setColor(Color.GREEN).setUrl(info.webpage_url).setFooter(info.format, info.thumbnail));
                                    break;
                                }
                                case ERROR: {
                                    msg.setContent("");
                                    embed.setTitle("ERROR").setColor(Color.ORANGE).setDescription("Something went wront.\n\n".concat(errorBuilder.toString()));
                                    break;
                                }
                                default: {
                                    msg.setContent("");
                                    embed.setTitle("WARNING").setDescription("Mediafile already downloaded and exists.").setColor(Color.ORANGE);
                                }
                            }
                        });
                    }).subscribe();
                    if (listener != null && !listener.isDisposed()) {
                        listener.dispose();
                    }
                    if (process.isAlive()) {
                        process.destroyForcibly();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }).doOnError(error -> ANSI.printErr("Error while downloading media in discord command.", error)).subscribe();
        }

        private static enum Status {
            NONE,
            RUNNING,
            ABORTED,
            TIMEOUT,
            EXISTS,
            ERROR,
            WARNING,
            FINISHED;

        }
    }
}

