/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.StreamType;
import com.github.kokorin.jaffree.ffmpeg.BaseInOut;
import com.github.kokorin.jaffree.ffmpeg.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class BaseOutput<T extends BaseOutput<T>>
extends BaseInOut<T>
implements Output {
    private final String output;
    private Long outputPosition;
    private Long sizeLimit;
    private final Map<String, Object> frames = new HashMap<String, Object>();
    private final Set<StreamType> disabledStreams = new LinkedHashSet<StreamType>();
    private final List<Mapping> maps = new ArrayList<Mapping>();
    private final List<Program> programs = new ArrayList<Program>();

    public BaseOutput(String output) {
        this.output = output;
    }

    public T setOutputPosition(long positionMillis) {
        this.outputPosition = positionMillis;
        return (T)((BaseOutput)this.thisAsT());
    }

    public T setOutputPosition(Number position, TimeUnit unit) {
        long millis = (long)(position.doubleValue() * (double)unit.toMillis(1L));
        return this.setOutputPosition(millis);
    }

    public T setSizeLimit(long sizeLimitBytes) {
        this.sizeLimit = sizeLimitBytes;
        return (T)((BaseOutput)this.thisAsT());
    }

    public T copyAllCodecs() {
        return this.copyCodec((String)null);
    }

    public T copyCodec(String streamSpecifier) {
        return (T)((BaseOutput)this.setCodec(streamSpecifier, "copy"));
    }

    public T copyCodec(StreamType streamType) {
        return (T)((BaseOutput)this.setCodec(streamType, "copy"));
    }

    public T disableStream(StreamType streamType) {
        this.disabledStreams.add(streamType);
        return (T)((BaseOutput)this.thisAsT());
    }

    public T setFrameCount(StreamType streamType, Long frameCount) {
        String key = null;
        if (streamType != null) {
            key = streamType.code();
        }
        this.frames.put(key, frameCount);
        return (T)((BaseOutput)this.thisAsT());
    }

    public T addMap(int inputFileIndex) {
        this.maps.add(new DefaultMapping(false, inputFileIndex, null, false));
        return (T)((BaseOutput)this.thisAsT());
    }

    public T addMap(int inputFileIndex, StreamType streamType) {
        this.maps.add(new DefaultMapping(false, inputFileIndex, streamType.code(), false));
        return (T)((BaseOutput)this.thisAsT());
    }

    public T addMap(int inputFileIndex, String streamSpecifier) {
        this.maps.add(new DefaultMapping(false, inputFileIndex, streamSpecifier, false));
        return (T)((BaseOutput)this.thisAsT());
    }

    public T addMap(String linkLabel) {
        this.maps.add(new LabelMapping(linkLabel));
        return (T)((BaseOutput)this.thisAsT());
    }

    public T addProgram(int number, String title, int ... streams) {
        String[] streamsStr = new String[streams.length];
        for (int i = 0; i < streams.length; ++i) {
            streamsStr[i] = String.valueOf(streams[i]);
        }
        return this.addProgram(number, title, streamsStr);
    }

    public T addProgram(int number, String title, String ... streams) {
        this.programs.add(new Program(number, title, streams));
        return (T)((BaseOutput)this.thisAsT());
    }

    @Override
    public final List<String> buildArguments() {
        ArrayList<String> result = new ArrayList<String>(super.buildArguments());
        if (this.outputPosition != null) {
            result.addAll(Arrays.asList("-to", BaseOutput.formatDuration(this.outputPosition)));
        }
        if (this.sizeLimit != null) {
            result.addAll(Arrays.asList("-fs", this.sizeLimit.toString()));
        }
        for (StreamType disabledStream : this.disabledStreams) {
            if (disabledStream == null) continue;
            this.addArgument("-" + disabledStream.code() + "n");
        }
        result.addAll(BaseOutput.toArguments("-frames", this.frames));
        for (Mapping map : this.maps) {
            result.addAll(Arrays.asList("-map", map.toValue()));
        }
        for (Program program : this.programs) {
            result.addAll(Arrays.asList("-program", program.toValue()));
        }
        result.addAll(this.getAdditionalArguments());
        if (this.output == null) {
            throw new IllegalArgumentException("Output must be specified");
        }
        result.add(this.output);
        return result;
    }

    private static class Program {
        private final Integer number;
        private final String title;
        private final String[] streams;

        Program(Integer number, String title, String[] streams) {
            this.number = number;
            this.title = title;
            this.streams = streams;
        }

        public String toValue() {
            StringBuilder result = new StringBuilder();
            if (this.title != null) {
                result.append("title=").append(this.title);
            }
            if (this.number != null) {
                if (result.length() > 0) {
                    result.append(':');
                }
                result.append("program_num=").append(this.number.toString());
            }
            if (result.length() > 0) {
                result.append(':');
            }
            for (int i = 0; i < this.streams.length; ++i) {
                if (i > 0) {
                    result.append(':');
                }
                result.append("st=").append(this.streams[i]);
            }
            return result.toString();
        }
    }

    private static final class LabelMapping
    implements Mapping {
        private final String linkLabel;

        private LabelMapping(String linkLabel) {
            this.linkLabel = linkLabel;
        }

        @Override
        public String toValue() {
            return "[" + this.linkLabel + "]";
        }
    }

    private static final class DefaultMapping
    implements Mapping {
        private final boolean negative;
        private final int inputFileId;
        private final String streamSpecifier;
        private final boolean optional;

        DefaultMapping(boolean negative, int inputFileId, String streamSpecifier, boolean optional) {
            this.negative = negative;
            this.inputFileId = inputFileId;
            this.streamSpecifier = streamSpecifier;
            this.optional = optional;
        }

        @Override
        public String toValue() {
            StringBuilder result = new StringBuilder();
            if (this.negative) {
                result.append("-");
            }
            result.append(this.inputFileId);
            if (this.streamSpecifier != null) {
                result.append(":").append(this.streamSpecifier);
            }
            if (this.optional) {
                result.append("?");
            }
            return result.toString();
        }
    }

    private static interface Mapping {
        public String toValue();
    }
}

